/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collection;
import java.util.Collections;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.DataStreamException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public class RaftClientReply
extends RaftClientMessage {
    private final boolean success;
    private final RaftException exception;
    private final Message message;
    private final long logIndex;
    private final Collection<RaftProtos.CommitInfoProto> commitInfos;

    public static Builder newBuilder() {
        return new Builder();
    }

    RaftClientReply(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, boolean success, Message message, RaftException exception, long logIndex, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        super(clientId, serverId, groupId, callId);
        this.success = success;
        this.message = message;
        this.exception = exception;
        this.logIndex = logIndex;
        Collection<Object> collection = this.commitInfos = commitInfos != null ? commitInfos : Collections.emptyList();
        if (exception != null) {
            Preconditions.assertTrue((!success ? 1 : 0) != 0, () -> "Inconsistent parameters: success && exception != null: " + this);
            Preconditions.assertTrue((boolean)ReflectionUtils.isInstance((Object)exception, (Class[])new Class[]{AlreadyClosedException.class, NotLeaderException.class, NotReplicatedException.class, LeaderNotReadyException.class, StateMachineException.class, DataStreamException.class, LeaderSteppingDownException.class, TransferLeadershipException.class, ReadException.class, ReadIndexException.class}), () -> "Unexpected exception class: " + this);
        }
    }

    public Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        return this.commitInfos;
    }

    public final boolean isRequest() {
        return false;
    }

    public long getLogIndex() {
        return this.logIndex;
    }

    public String toString() {
        return super.toString() + ", " + (this.isSuccess() ? "SUCCESS" : "FAILED " + this.exception) + ", logIndex=" + this.getLogIndex() + ", commits" + ProtoUtils.toString((Collection)this.commitInfos);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Message getMessage() {
        return this.message;
    }

    public AlreadyClosedException getAlreadyClosedException() {
        return (AlreadyClosedException)JavaUtils.cast((Object)this.exception, AlreadyClosedException.class);
    }

    public NotLeaderException getNotLeaderException() {
        return (NotLeaderException)JavaUtils.cast((Object)this.exception, NotLeaderException.class);
    }

    public NotReplicatedException getNotReplicatedException() {
        return (NotReplicatedException)JavaUtils.cast((Object)this.exception, NotReplicatedException.class);
    }

    public StateMachineException getStateMachineException() {
        return (StateMachineException)JavaUtils.cast((Object)this.exception, StateMachineException.class);
    }

    public DataStreamException getDataStreamException() {
        return (DataStreamException)JavaUtils.cast((Object)this.exception, DataStreamException.class);
    }

    public LeaderNotReadyException getLeaderNotReadyException() {
        return (LeaderNotReadyException)JavaUtils.cast((Object)this.exception, LeaderNotReadyException.class);
    }

    public LeaderSteppingDownException getLeaderSteppingDownException() {
        return (LeaderSteppingDownException)JavaUtils.cast((Object)this.exception, LeaderSteppingDownException.class);
    }

    public TransferLeadershipException getTransferLeadershipException() {
        return (TransferLeadershipException)JavaUtils.cast((Object)this.exception, TransferLeadershipException.class);
    }

    public ReadException getReadException() {
        return (ReadException)JavaUtils.cast((Object)this.exception, ReadException.class);
    }

    public ReadIndexException getReadIndexException() {
        return (ReadIndexException)JavaUtils.cast((Object)this.exception, ReadIndexException.class);
    }

    public RaftException getException() {
        return this.exception;
    }
}

