/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;

public final class RaftGroup {
    private static final RaftGroup EMPTY_GROUP = new RaftGroup();
    private final RaftGroupId groupId;
    private final Map<RaftPeerId, RaftPeer> peers;

    public static RaftGroup emptyGroup() {
        return EMPTY_GROUP;
    }

    public static RaftGroup valueOf(RaftGroupId groupId, RaftPeer ... peers) {
        return new RaftGroup(groupId, peers == null || peers.length == 0 ? Collections.emptyList() : Arrays.asList(peers));
    }

    public static RaftGroup valueOf(RaftGroupId groupId, Iterable<RaftPeer> peers) {
        return new RaftGroup(groupId, peers);
    }

    private RaftGroup() {
        this.groupId = RaftGroupId.emptyGroupId();
        this.peers = Collections.emptyMap();
    }

    private RaftGroup(RaftGroupId groupId, Iterable<RaftPeer> peers) {
        this.groupId = Objects.requireNonNull(groupId, "groupId == null");
        Preconditions.assertTrue((!groupId.equals((Object)EMPTY_GROUP.getGroupId()) ? 1 : 0) != 0, () -> "Group Id " + groupId + " is reserved for the empty group.");
        if (peers == null || !peers.iterator().hasNext()) {
            this.peers = Collections.emptyMap();
        } else {
            Preconditions.assertUnique(peers);
            HashMap map = new HashMap();
            peers.forEach(p -> map.put(p.getId(), p));
            this.peers = Collections.unmodifiableMap(map);
        }
    }

    public RaftGroupId getGroupId() {
        return this.groupId;
    }

    public Collection<RaftPeer> getPeers() {
        return this.peers.values();
    }

    public RaftPeer getPeer(RaftPeerId id) {
        return (RaftPeer)this.peers.get(Objects.requireNonNull(id, "id == null"));
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RaftGroup)) {
            return false;
        }
        RaftGroup that = (RaftGroup)obj;
        return this.groupId.equals((Object)that.groupId) && this.peers.equals(that.peers);
    }

    public String toString() {
        return this.groupId + ":" + this.peers.values();
    }
}

