/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public final class ExceptionDependentRetry
implements RetryPolicy {
    private final RetryPolicy defaultPolicy;
    private final Map<String, RetryPolicy> exceptionNameToPolicyMap;
    private final int maxAttempts;
    private final Supplier<String> toStringSupplier;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ExceptionDependentRetry(RetryPolicy defaultPolicy, Map<String, RetryPolicy> policyMap, int maxAttempts) {
        Preconditions.assertTrue((defaultPolicy != null ? 1 : 0) != 0, (Object)"Default Policy should not be null");
        this.defaultPolicy = defaultPolicy;
        this.exceptionNameToPolicyMap = Collections.unmodifiableMap(policyMap);
        this.maxAttempts = maxAttempts;
        this.toStringSupplier = JavaUtils.memoize(() -> {
            StringBuilder b = new StringBuilder(JavaUtils.getClassSimpleName(this.getClass())).append("(").append("maxAttempts=").append(maxAttempts).append("; ").append("defaultPolicy=").append(defaultPolicy).append("; ").append("map={");
            policyMap.forEach((key, value) -> b.append((String)key).append("->").append(value).append(", "));
            b.setLength(b.length() - 2);
            return b.append("})").toString();
        });
    }

    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        RetryPolicy policy = null;
        if (event.getCause() != null) {
            policy = (RetryPolicy)this.exceptionNameToPolicyMap.get(event.getCause().getClass().getName());
        }
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        return event.getAttemptCount() < this.maxAttempts ? policy.handleAttemptFailure(() -> ((RetryPolicy.Event)event).getCauseCount()) : NO_RETRY_ACTION;
    }

    public String toString() {
        return (String)this.toStringSupplier.get();
    }
}

