/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeInjectionForTesting {
    public static final Logger LOG = LoggerFactory.getLogger(CodeInjectionForTesting.class);
    private static final Map<String, Code> INJECTION_POINTS = new ConcurrentHashMap();

    private CodeInjectionForTesting() {
    }

    public static void put(String injectionPoint, Code code) {
        LOG.debug("put: {}, {}", (Object)injectionPoint, (Object)code);
        INJECTION_POINTS.put(injectionPoint, code);
    }

    public static boolean execute(String injectionPoint, Object localId, Object remoteId, Object ... args) {
        Code code = (Code)INJECTION_POINTS.get(injectionPoint);
        if (code == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("execute: {}, {}, localId={}, remoteId={}, args={}", new Object[]{injectionPoint, code, localId, remoteId, Arrays.toString(args)});
        }
        return code.execute(localId, remoteId, args);
    }
}

