/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LifeCycle {
    public static final Logger LOG = LoggerFactory.getLogger(LifeCycle.class);
    private volatile String name;
    private final AtomicReference<State> current = new AtomicReference<State>(State.NEW);

    public LifeCycle(Object name) {
        this.name = name.toString();
        LOG.debug("{}: {}", name, (Object)this.current);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void transition(State to) {
        State from = this.current.getAndSet(to);
        State.validate((Object)this.name, (State)from, (State)to);
    }

    public void transitionIfNotEqual(State to) {
        State from = this.current.getAndSet(to);
        if (from != to) {
            State.validate((Object)this.name, (State)from, (State)to);
        }
    }

    public boolean transitionIfValid(State to) {
        State updated = (State)this.current.updateAndGet(from -> State.isValid((State)from, (State)to) ? to : from);
        return updated == to;
    }

    public State transition(UnaryOperator<State> operator) {
        State applied;
        State previous;
        do {
            if ((previous = (State)this.current.get()) == (applied = (State)operator.apply(previous))) {
                return null;
            }
            State.validate((Object)this.name, (State)previous, (State)applied);
        } while (!this.current.compareAndSet(previous, applied));
        return applied;
    }

    public State transitionAndGet(UnaryOperator<State> operator) {
        return (State)this.current.updateAndGet(previous -> {
            State applied = (State)operator.apply((State)previous);
            if (applied != previous) {
                State.validate((Object)this.name, (State)previous, (State)applied);
            }
            return applied;
        });
    }

    public boolean compareAndTransition(State from, State to) {
        if (this.current.compareAndSet(from, to)) {
            State.validate((Object)this.name, (State)from, (State)to);
            return true;
        }
        return false;
    }

    public State getCurrentState() {
        return (State)this.current.get();
    }

    public void assertCurrentState(Set<State> expected) {
        this.assertCurrentState((n, c) -> new IllegalStateException("STATE MISMATCHED: In " + n + ", current state " + c + " is not one of the expected states " + expected), expected);
    }

    public <T extends Throwable> State assertCurrentState(BiFunction<String, State, T> newThrowable, Set<State> expected) throws T {
        State c = this.getCurrentState();
        if (!expected.contains(c)) {
            throw (Throwable)newThrowable.apply(this.name, c);
        }
        return c;
    }

    public String toString() {
        return this.name + ":" + this.getCurrentState();
    }

    @SafeVarargs
    public final <T extends Throwable> void startAndTransition(CheckedRunnable<T> startImpl, Class<? extends Throwable> ... exceptionClasses) throws T {
        this.transition(State.STARTING);
        try {
            startImpl.run();
            this.transition(State.RUNNING);
        }
        catch (Throwable t) {
            this.transition(ReflectionUtils.isInstance((Object)t, (Class[])exceptionClasses) ? State.NEW : State.EXCEPTION);
            throw t;
        }
    }

    public State checkStateAndClose() {
        return this.checkStateAndClose(() -> State.CLOSING);
    }

    public <T extends Throwable> State checkStateAndClose(CheckedRunnable<T> closeMethod) throws T {
        return this.checkStateAndClose(() -> {
            try {
                closeMethod.run();
            }
            finally {
                this.transition(State.CLOSED);
            }
            return State.CLOSED;
        });
    }

    private <T extends Throwable> State checkStateAndClose(CheckedSupplier<State, T> closeMethod) throws T {
        State c;
        if (this.compareAndTransition(State.NEW, State.CLOSED)) {
            return State.CLOSED;
        }
        do {
            if (!(c = this.getCurrentState()).isClosingOrClosed()) continue;
            return c;
        } while (!this.compareAndTransition(c, State.CLOSING));
        return (State)closeMethod.get();
    }
}

