/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.util.AtomicFileOutputStream;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MD5FileUtil {
    public static final Logger LOG = LoggerFactory.getLogger(MD5FileUtil.class);
    public static final String MD5_SUFFIX = ".md5";
    private static final Pattern LINE_REGEX = Pattern.compile("([0-9a-f]{32}) [ *](.+)");

    public static void verifySavedMD5(File dataFile, MD5Hash expectedMD5) throws IOException {
        MD5Hash storedHash = MD5FileUtil.readStoredMd5ForFile((File)dataFile);
        if (!expectedMD5.equals((Object)storedHash)) {
            throw new IOException("File " + dataFile + " did not match stored MD5 checksum  (stored: " + storedHash + ", computed: " + expectedMD5);
        }
    }

    private static Matcher readStoredMd5(File md5File) throws IOException {
        String md5Line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(md5File), StandardCharsets.UTF_8));
        try {
            md5Line = reader.readLine();
            if (md5Line == null) {
                md5Line = "";
            }
            md5Line = md5Line.trim();
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Error reading md5 file at " + md5File, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{reader});
                throw throwable;
            }
        }
        IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{reader});
        Matcher matcher = LINE_REGEX.matcher(md5Line);
        if (!matcher.matches()) {
            throw new IOException("Invalid MD5 file " + md5File + ": the content \"" + md5Line + "\" does not match the expected pattern.");
        }
        return matcher;
    }

    public static MD5Hash readStoredMd5ForFile(File dataFile) throws IOException {
        File md5File = MD5FileUtil.getDigestFileForFile((File)dataFile);
        if (!md5File.exists()) {
            return null;
        }
        Matcher matcher = MD5FileUtil.readStoredMd5((File)md5File);
        String storedHash = matcher.group(1);
        File referencedFile = new File(matcher.group(2));
        if (!referencedFile.getName().equals(dataFile.getName())) {
            throw new IOException("MD5 file at " + md5File + " references file named " + referencedFile.getName() + " but we expected it to reference " + dataFile);
        }
        return new MD5Hash(storedHash);
    }

    public static MD5Hash computeMd5ForFile(File dataFile) throws IOException {
        MessageDigest digester = MD5Hash.getDigester();
        try (DigestInputStream dis = new DigestInputStream(Files.newInputStream(dataFile.toPath(), new OpenOption[0]), digester);){
            IOUtils.readFully((InputStream)dis, (int)131072);
        }
        return new MD5Hash(digester.digest());
    }

    public static MD5Hash computeAndSaveMd5ForFile(File dataFile) {
        MD5Hash md5;
        try {
            md5 = MD5FileUtil.computeMd5ForFile((File)dataFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compute MD5 for file " + dataFile, e);
        }
        try {
            MD5FileUtil.saveMD5File((File)dataFile, (MD5Hash)md5);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save MD5 " + md5 + " for file " + dataFile, e);
        }
        return md5;
    }

    public static void saveMD5File(File dataFile, MD5Hash digest) throws IOException {
        String digestString = StringUtils.bytes2HexString((byte[])digest.getDigest());
        MD5FileUtil.saveMD5File((File)dataFile, (String)digestString);
    }

    private static void saveMD5File(File dataFile, String digestString) throws IOException {
        File md5File = MD5FileUtil.getDigestFileForFile((File)dataFile);
        String md5Line = digestString + " *" + dataFile.getName() + "\n";
        try (AtomicFileOutputStream afos = new AtomicFileOutputStream(md5File);){
            afos.write(md5Line.getBytes(StandardCharsets.UTF_8));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saved MD5 " + digestString + " to " + md5File);
        }
    }

    public static void renameMD5File(File oldDataFile, File newDataFile) throws IOException {
        File fromFile = MD5FileUtil.getDigestFileForFile((File)oldDataFile);
        if (!fromFile.exists()) {
            throw new FileNotFoundException(fromFile + " does not exist.");
        }
        String digestString = MD5FileUtil.readStoredMd5((File)fromFile).group(1);
        MD5FileUtil.saveMD5File((File)newDataFile, (String)digestString);
        if (!fromFile.delete()) {
            LOG.warn("deleting  " + fromFile.getAbsolutePath() + " FAILED");
        }
    }

    public static File getDigestFileForFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".md5");
    }
}

