/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;

/*
 * Exception performing whole class analysis ignored.
 */
public interface Preconditions {
    public static void assertTrue(boolean value) {
        if (!value) {
            throw new IllegalStateException();
        }
    }

    public static void assertTrue(boolean value, Object message) {
        if (!value) {
            throw new IllegalStateException(String.valueOf(message));
        }
    }

    public static void assertTrue(boolean value, String format, Object ... args) {
        if (!value) {
            throw new IllegalStateException(String.format(format, args));
        }
    }

    public static void assertTrue(boolean value, Supplier<Object> message) {
        if (!value) {
            throw new IllegalStateException(String.valueOf(message.get()));
        }
    }

    public static void assertSame(long expected, long computed, String name) {
        Preconditions.assertTrue((expected == computed ? 1 : 0) != 0, () -> name + ": expected == " + expected + " but computed == " + computed);
    }

    public static void assertSame(Object expected, Object computed, String name) {
        Preconditions.assertTrue((expected == computed ? 1 : 0) != 0, () -> name + ": expected == " + expected + " but computed == " + computed);
    }

    public static void assertNull(Object object, Supplier<String> message) {
        Preconditions.assertTrue((object == null ? 1 : 0) != 0, message);
    }

    public static void assertNull(Object object, String name) {
        Preconditions.assertNull((Object)object, () -> name + " is expected to be null but " + name + " = " + object + " != null, class = " + object.getClass());
    }

    public static <T> T assertNotNull(T object, Supplier<String> message) {
        Preconditions.assertTrue((object != null ? 1 : 0) != 0, message);
        return object;
    }

    public static <T> T assertNotNull(T object, String name) {
        return (T)Preconditions.assertNotNull(object, () -> name + " is expected to not be null but " + name + " = " + object + " == null, class = " + object.getClass());
    }

    public static <T> T assertNotNull(T object, String format, Object ... args) {
        Preconditions.assertTrue((object != null ? 1 : 0) != 0, (String)format, (Object[])args);
        return object;
    }

    public static <T> T assertInstanceOf(Object object, Class<T> clazz) {
        Preconditions.assertTrue((boolean)clazz.isInstance(object), () -> "Required instance of " + clazz + " but object.getClass() is " + object.getClass());
        return clazz.cast(object);
    }

    public static <T> void assertUnique(Iterable<T> first) {
        Preconditions.assertUnique(first, Collections.emptyList());
    }

    public static <T> void assertUnique(Iterable<T> original, Iterable<T> toBeAdded) {
        HashSet<T> set = new HashSet<T>();
        for (Object t : original) {
            Preconditions.assertTrue((boolean)set.add(t), () -> "Found duplicated element " + t + " in " + original);
        }
        for (Object t : toBeAdded) {
            Preconditions.assertTrue((boolean)set.add(t), () -> "Found duplicated element " + t + " when adding " + toBeAdded + " to " + original);
        }
    }
}

