/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.apache.ratis.util.TimeoutTimer;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutTimer
implements TimeoutExecutor {
    public static final Logger LOG = LoggerFactory.getLogger(TimeoutTimer.class);
    private static final Supplier<TimeoutTimer> INSTANCE = JavaUtils.memoize(() -> new TimeoutTimer(8));
    private final AtomicInteger numTasks = new AtomicInteger();
    private final AtomicInteger taskId = new AtomicInteger();
    private final List<MemoizedSupplier<Timer>> timers;

    public static TimeoutTimer getInstance() {
        return (TimeoutTimer)INSTANCE.get();
    }

    private TimeoutTimer(int numTimers) {
        ArrayList<MemoizedSupplier> list = new ArrayList<MemoizedSupplier>(numTimers);
        for (int i = 0; i < numTimers; ++i) {
            String name = "timer" + i;
            list.add(JavaUtils.memoize(() -> new Timer(name, true)));
        }
        this.timers = Collections.unmodifiableList(list);
    }

    public int getTaskCount() {
        return this.numTasks.get();
    }

    private Timer getTimer(int tid) {
        return (Timer)((MemoizedSupplier)this.timers.get(Math.toIntExact(Integer.toUnsignedLong(tid) % (long)this.timers.size()))).get();
    }

    private void schedule(TimeDuration timeout, Runnable toSchedule) {
        int tid = this.taskId.incrementAndGet();
        int n = this.numTasks.incrementAndGet();
        LOG.debug("schedule a task #{} with timeout {}, numTasks={}", new Object[]{tid, timeout, n});
        this.getTimer(n).schedule((TimerTask)new Task(tid, toSchedule), timeout.toLong(TimeUnit.MILLISECONDS));
    }

    public <THROWABLE extends Throwable> void onTimeout(TimeDuration timeout, CheckedRunnable<THROWABLE> task, Consumer<THROWABLE> errorHandler) {
        this.schedule(timeout, () -> {
            try {
                task.run();
            }
            catch (Throwable t) {
                errorHandler.accept(JavaUtils.cast((Object)t));
            }
            finally {
                this.numTasks.decrementAndGet();
            }
        });
    }
}

