/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.com.google.common.base.Objects;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public interface ConfUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ConfUtils.class);

    public static <T> void logGet(String key, T value, T defaultValue, Consumer<String> logger) {
        if (logger != null) {
            logger.accept(String.format("%s = %s (%s)", key, value, Objects.equal(value, defaultValue) ? "default" : "custom"));
        }
    }

    public static <T> void logFallback(String key, String fallbackKey, T fallbackValue, Consumer<String> logger) {
        if (logger != null) {
            logger.accept(String.format("%s = %s (fallback to %s)", key, fallbackValue, fallbackKey));
        }
    }

    public static void logSet(String key, Object value) {
        LOG.debug("set {} = {}", (Object)key, value);
    }

    public static BiConsumer<String, Integer> requireMin(int min) {
        return (key, value) -> {
            if (value < min) {
                throw new IllegalArgumentException(key + " = " + value + " < min = " + min);
            }
        };
    }

    public static BiConsumer<String, Integer> requireMax(int max) {
        return (key, value) -> {
            if (value > max) {
                throw new IllegalArgumentException(key + " = " + value + " > max = " + max);
            }
        };
    }

    public static BiConsumer<String, Double> requireMin(double min) {
        return (key, value) -> {
            if (value < min) {
                throw new IllegalArgumentException(key + " = " + value + " < min = " + min);
            }
        };
    }

    public static BiConsumer<String, Double> requireMax(double max) {
        return (key, value) -> {
            if (value > max) {
                throw new IllegalArgumentException(key + " = " + value + " > max = " + max);
            }
        };
    }

    public static BiConsumer<String, Long> requireMin(SizeInBytes min) {
        return ConfUtils.requireMin((long)min.getSize());
    }

    public static BiConsumer<String, Long> requireMin(long min) {
        return (key, value) -> {
            if (value < min) {
                throw new IllegalArgumentException(key + " = " + value + " < min = " + min);
            }
        };
    }

    public static BiConsumer<String, SizeInBytes> requireMinSizeInByte(SizeInBytes min) {
        return (key, value) -> {
            if (value.getSize() < min.getSize()) {
                throw new IllegalArgumentException(key + " = " + value + " < min = " + min);
            }
        };
    }

    public static BiConsumer<String, Long> requireMax(long max) {
        return (key, value) -> {
            if (value > max) {
                throw new IllegalArgumentException(key + " = " + value + " > max = " + max);
            }
        };
    }

    public static BiConsumer<String, TimeDuration> requireNonNegativeTimeDuration() {
        return (key, value) -> {
            if (value.isNegative()) {
                throw new IllegalArgumentException(key + " = " + value + " is negative.");
            }
        };
    }

    public static BiConsumer<String, TimeDuration> requirePositive() {
        return (key, value) -> {
            if (value.getDuration() <= 0L) {
                throw new IllegalArgumentException(key + " = " + value + " is non-positive.");
            }
        };
    }

    public static BiFunction<String, Long, Integer> requireInt() {
        return (key, value) -> {
            try {
                return Math.toIntExact(value);
            }
            catch (ArithmeticException ae) {
                throw new IllegalArgumentException("Failed to cast " + key + " = " + value + " to int.", ae);
            }
        };
    }

    @SafeVarargs
    public static boolean getBoolean(BiFunction<String, Boolean, Boolean> booleanGetter, String key, boolean defaultValue, Consumer<String> logger, BiConsumer<String, Boolean> ... assertions) {
        return (Boolean)ConfUtils.get(booleanGetter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static int getInt(BiFunction<String, Integer, Integer> integerGetter, String key, int defaultValue, Consumer<String> logger, BiConsumer<String, Integer> ... assertions) {
        return (Integer)ConfUtils.get(integerGetter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static int getInt(BiFunction<String, Integer, Integer> integerGetter, String key, int defaultValue, String fallbackKey, int fallbackValue, Consumer<String> logger, BiConsumer<String, Integer> ... assertions) {
        return (Integer)ConfUtils.get(integerGetter, (String)key, (Object)defaultValue, (String)fallbackKey, (Object)fallbackValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static long getLong(BiFunction<String, Long, Long> longGetter, String key, long defaultValue, Consumer<String> logger, BiConsumer<String, Long> ... assertions) {
        return (Long)ConfUtils.get(longGetter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static double getDouble(BiFunction<String, Double, Double> doubleGetter, String key, double defaultValue, Consumer<String> logger, BiConsumer<String, Double> ... assertions) {
        return (Double)ConfUtils.get(doubleGetter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static File getFile(BiFunction<String, File, File> fileGetter, String key, File defaultValue, Consumer<String> logger, BiConsumer<String, File> ... assertions) {
        return (File)ConfUtils.get(fileGetter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static List<File> getFiles(BiFunction<String, List<File>, List<File>> fileGetter, String key, List<File> defaultValue, Consumer<String> logger, BiConsumer<String, List<File>> ... assertions) {
        return (List)ConfUtils.get(fileGetter, (String)key, defaultValue, logger, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static SizeInBytes getSizeInBytes(BiFunction<String, SizeInBytes, SizeInBytes> getter, String key, SizeInBytes defaultValue, Consumer<String> logger, BiConsumer<String, SizeInBytes> ... assertions) {
        SizeInBytes value = (SizeInBytes)ConfUtils.get(getter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
        ConfUtils.requireMin((long)0L).accept(key, value.getSize());
        return value;
    }

    @SafeVarargs
    public static TimeDuration getTimeDuration(BiFunction<String, TimeDuration, TimeDuration> getter, String key, TimeDuration defaultValue, Consumer<String> logger, BiConsumer<String, TimeDuration> ... assertions) {
        TimeDuration value = (TimeDuration)ConfUtils.get(getter, (String)key, (Object)defaultValue, logger, (BiConsumer[])assertions);
        ConfUtils.requireNonNegativeTimeDuration().accept(key, value);
        return value;
    }

    @SafeVarargs
    public static TimeDuration getTimeDuration(BiFunction<String, TimeDuration, TimeDuration> getter, String key, TimeDuration defaultValue, String fallbackKey, TimeDuration fallbackValue, Consumer<String> logger, BiConsumer<String, TimeDuration> ... assertions) {
        TimeDuration value = (TimeDuration)ConfUtils.get(getter, (String)key, (Object)defaultValue, (String)fallbackKey, (Object)fallbackValue, logger, (BiConsumer[])assertions);
        ConfUtils.requireNonNegativeTimeDuration().accept(key, value);
        return value;
    }

    public static TlsConf getTlsConf(Function<String, TlsConf> tlsConfGetter, String key, Consumer<String> logger) {
        return (TlsConf)ConfUtils.get((T k, U d) -> (TlsConf)tlsConfGetter.apply((String)k), (String)key, null, logger, (BiConsumer[])new BiConsumer[0]);
    }

    @SafeVarargs
    public static <T> T get(BiFunction<String, T, T> getter, String key, T defaultValue, Consumer<String> logger, BiConsumer<String, T> ... assertions) {
        Object value = getter.apply(key, (String)defaultValue);
        ConfUtils.logGet((String)key, value, defaultValue, logger);
        Arrays.asList(assertions).forEach(a -> a.accept(key, value));
        return value;
    }

    @SafeVarargs
    public static <T> T get(BiFunction<String, T, T> getter, String key, T defaultValue, String fallbackKey, T fallbackValue, Consumer<String> logger, BiConsumer<String, T> ... assertions) {
        Object value = ConfUtils.get(getter, (String)key, defaultValue, null, (BiConsumer[])assertions);
        if (value != defaultValue) {
            ConfUtils.logGet((String)key, (Object)value, defaultValue, logger);
            return (T)value;
        }
        ConfUtils.logFallback((String)key, (String)fallbackKey, fallbackValue, logger);
        return fallbackValue;
    }

    public static InetSocketAddress getInetSocketAddress(BiFunction<String, String, String> stringGetter, String key, String defaultValue, Consumer<String> logger) {
        return NetUtils.createSocketAddr((String)((String)ConfUtils.get(stringGetter, (String)key, (Object)defaultValue, logger, (BiConsumer[])new BiConsumer[0])));
    }

    @SafeVarargs
    public static void setBoolean(BiConsumer<String, Boolean> booleanSetter, String key, boolean value, BiConsumer<String, Boolean> ... assertions) {
        ConfUtils.set(booleanSetter, (String)key, (Object)value, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static void setInt(BiConsumer<String, Integer> integerSetter, String key, int value, BiConsumer<String, Integer> ... assertions) {
        ConfUtils.set(integerSetter, (String)key, (Object)value, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static void setLong(BiConsumer<String, Long> longSetter, String key, long value, BiConsumer<String, Long> ... assertions) {
        ConfUtils.set(longSetter, (String)key, (Object)value, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static void setDouble(BiConsumer<String, Double> doubleSetter, String key, double value, BiConsumer<String, Double> ... assertions) {
        ConfUtils.set(doubleSetter, (String)key, (Object)value, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static void setFile(BiConsumer<String, File> fileSetter, String key, File value, BiConsumer<String, File> ... assertions) {
        ConfUtils.set(fileSetter, (String)key, (Object)value, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static void setFiles(BiConsumer<String, List<File>> fileSetter, String key, List<File> value, BiConsumer<String, List<File>> ... assertions) {
        ConfUtils.set(fileSetter, (String)key, value, (BiConsumer[])assertions);
    }

    @SafeVarargs
    public static void setSizeInBytes(BiConsumer<String, String> stringSetter, String key, SizeInBytes value, BiConsumer<String, Long> ... assertions) {
        long v = value.getSize();
        Arrays.asList(assertions).forEach(a -> a.accept(key, v));
        ConfUtils.set(stringSetter, (String)key, (Object)value.getInput(), (BiConsumer[])new BiConsumer[0]);
    }

    @SafeVarargs
    public static void setTimeDuration(BiConsumer<String, TimeDuration> timeDurationSetter, String key, TimeDuration value, BiConsumer<String, TimeDuration> ... assertions) {
        ConfUtils.set(timeDurationSetter, (String)key, (Object)value, (BiConsumer[])assertions);
    }

    public static void setTlsConf(BiConsumer<String, TlsConf> tlsConfSetter, String key, TlsConf value) {
        ConfUtils.set(tlsConfSetter, (String)key, (Object)value, (BiConsumer[])new BiConsumer[0]);
    }

    @SafeVarargs
    public static <T> void set(BiConsumer<String, T> setter, String key, T value, BiConsumer<String, T> ... assertions) {
        Arrays.asList(assertions).forEach(a -> a.accept(key, value));
        setter.accept(key, (String)value);
        ConfUtils.logSet((String)key, value);
    }

    public static void printAll(Class<?> confClass) {
        ConfUtils.printAll(confClass, System.out::println);
    }

    public static void printAll(Class<?> confClass, Consumer<Object> out) {
        if (confClass.isEnum()) {
            return;
        }
        out.accept("");
        out.accept("******* " + confClass + " *******");
        Arrays.asList(confClass.getDeclaredFields()).forEach(f -> ConfUtils.printField((Class)confClass, (Consumer)out, (Field)f));
        Arrays.asList(confClass.getClasses()).forEach(c -> ConfUtils.printAll((Class)c, (T s) -> out.accept("  " + s)));
    }

    public static void printField(Class<?> confClass, Consumer<Object> out, Field f) {
        int modifiers = f.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new IllegalStateException("Found non-static field " + f);
        }
        if (!Modifier.isFinal(modifiers)) {
            throw new IllegalStateException("Found non-final field " + f);
        }
        if (ConfUtils.printKey(confClass, out, (Field)f, (String)"KEY", (String)"DEFAULT", ConfUtils::append)) {
            return;
        }
        if (ConfUtils.printKey(confClass, out, (Field)f, (String)"PARAMETER", (String)"CLASS", (b, classField) -> b.append(classField.get(null)))) {
            return;
        }
        String fieldName = f.getName();
        if ("LOG".equals(fieldName)) {
            return;
        }
        if (!"PREFIX".equals(fieldName)) {
            throw new IllegalStateException("Unexpected field: " + fieldName);
        }
        try {
            out.accept("constant: " + fieldName + " = " + f.get(null));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to access " + f, e);
        }
    }

    public static void append(StringBuilder b, Field defaultField) throws IllegalAccessException {
        b.append(defaultField.getGenericType().getTypeName());
        Class<?> type = defaultField.getType();
        if (type.isEnum()) {
            b.append(" enum[");
            for (Object e : defaultField.getType().getEnumConstants()) {
                b.append(e).append(", ");
            }
            b.setLength(b.length() - 2);
            b.append("]");
        }
        b.append(", ").append("default=").append(defaultField.get(null));
    }

    public static boolean printKey(Class<?> confClass, Consumer<Object> out, Field f, String key, String defaultName, CheckedBiConsumer<StringBuilder, Field, IllegalAccessException> processDefault) {
        Object keyName;
        String fieldName = f.getName();
        if (fieldName.endsWith("_" + defaultName)) {
            return true;
        }
        if (!fieldName.endsWith("_" + key)) {
            return false;
        }
        StringBuilder b = new StringBuilder();
        try {
            keyName = f.get(null);
            b.append(key.toLowerCase()).append(": ").append(keyName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to access " + fieldName, e);
        }
        ConfUtils.assertKey((String)fieldName, (int)key.length(), (Object)keyName, confClass);
        String defaultFieldName = fieldName.substring(0, fieldName.length() - key.length()) + defaultName;
        b.append(" (");
        try {
            Field defaultField = confClass.getDeclaredField(defaultFieldName);
            processDefault.accept((Object)b, (Object)defaultField);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(defaultName + " not found for field " + f, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to access " + defaultFieldName, e);
        }
        b.append(")");
        out.accept(b);
        return true;
    }

    public static String normalizeName(String name) {
        return name.replaceAll("[._-]", "").toLowerCase();
    }

    public static void assertKey(String fieldName, int toTruncate, Object keyName, Class<?> confClass) {
        String normalizedFieldName = ConfUtils.normalizeName((String)fieldName.substring(0, fieldName.length() - toTruncate));
        String normalizedKeyName = ConfUtils.normalizeName((String)("" + keyName));
        if (!normalizedKeyName.endsWith(normalizedFieldName)) {
            throw new IllegalStateException("Field and key mismatched: fieldName = " + fieldName + " (" + normalizedFieldName + ") but keyName = " + keyName + " (" + normalizedKeyName + ")");
        }
        boolean getter = false;
        boolean setter = false;
        for (Method m : confClass.getMethods()) {
            String name = m.getName();
            if (name.equalsIgnoreCase(normalizedFieldName)) {
                getter = true;
            }
            if (!name.equalsIgnoreCase("set" + normalizedFieldName)) continue;
            setter = true;
        }
        if (!getter) {
            throw new IllegalStateException("Getter method not found for " + fieldName);
        }
        if (!setter) {
            throw new IllegalStateException("Setter method not found for " + fieldName);
        }
    }
}

