/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.datastream.impl;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamReply;

public final class DataStreamReplyByteBuffer
extends DataStreamPacketByteBuffer
implements DataStreamReply {
    private final boolean success;
    private final long bytesWritten;
    private final Collection<RaftProtos.CommitInfoProto> commitInfos;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    private DataStreamReplyByteBuffer(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, ByteBuffer buffer, boolean success, long bytesWritten, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        super(clientId, type, streamId, streamOffset, buffer);
        this.success = success;
        this.bytesWritten = bytesWritten;
        this.commitInfos = commitInfos != null ? commitInfos : Collections.emptyList();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        return this.commitInfos;
    }

    public String toString() {
        return super.toString() + "," + (this.success ? "SUCCESS" : "FAILED") + ",bytesWritten=" + this.bytesWritten;
    }
}

