/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collections;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.util.ProtoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftClientRequest
extends RaftClientMessage {
    private static final Type DATA_STREAM_DEFAULT = new Type(RaftProtos.DataStreamRequestTypeProto.getDefaultInstance(), null);
    private static final Type FORWARD_DEFAULT = new Type(RaftProtos.ForwardRequestTypeProto.getDefaultInstance(), null);
    private static final Type WRITE_DEFAULT = new Type(RaftProtos.WriteRequestTypeProto.getDefaultInstance(), null);
    private static final Type WATCH_DEFAULT = new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(0L).setReplication(RaftProtos.ReplicationLevel.MAJORITY).build(), null);
    private static final Type READ_AFTER_WRITE_CONSISTENT_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.newBuilder().setReadAfterWriteConsistent(true).build(), null);
    private static final Type READ_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.getDefaultInstance(), null);
    private static final Type READ_NONLINEARIZABLE_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.newBuilder().setPreferNonLinearizable(true).build(), null);
    private static final Type STALE_READ_DEFAULT = new Type(RaftProtos.StaleReadRequestTypeProto.getDefaultInstance(), null);
    private final Message message;
    private final Type type;
    private final Iterable<Long> repliedCallIds;
    private final RaftProtos.SlidingWindowEntry slidingWindowEntry;
    private final RoutingTable routingTable;
    private final long timeoutMs;
    private final boolean toLeader;

    public static Type writeRequestType() {
        return WRITE_DEFAULT;
    }

    public static Type dataStreamRequestType() {
        return DATA_STREAM_DEFAULT;
    }

    public static Type forwardRequestType() {
        return FORWARD_DEFAULT;
    }

    public static Type messageStreamRequestType(long streamId, long messageId, boolean endOfRequest) {
        return new Type(RaftProtos.MessageStreamRequestTypeProto.newBuilder().setStreamId(streamId).setMessageId(messageId).setEndOfRequest(endOfRequest).build(), null);
    }

    public static Type readAfterWriteConsistentRequestType() {
        return READ_AFTER_WRITE_CONSISTENT_DEFAULT;
    }

    public static Type readRequestType() {
        return READ_DEFAULT;
    }

    public static Type readRequestType(boolean nonLinearizable) {
        return nonLinearizable ? READ_NONLINEARIZABLE_DEFAULT : RaftClientRequest.readRequestType();
    }

    public static Type staleReadRequestType(long minIndex) {
        return minIndex == 0L ? STALE_READ_DEFAULT : new Type(RaftProtos.StaleReadRequestTypeProto.newBuilder().setMinIndex(minIndex).build(), null);
    }

    public static Type watchRequestType() {
        return WATCH_DEFAULT;
    }

    public static Type watchRequestType(long index, RaftProtos.ReplicationLevel replication) {
        return new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(index).setReplication(replication).build(), null);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RaftClientRequest toWriteRequest(RaftClientRequest r, Message message) {
        return RaftClientRequest.newBuilder().setClientId(r.getClientId()).setServerId(r.getServerId()).setGroupId(r.getRaftGroupId()).setCallId(r.getCallId()).setMessage(message).setType(RaftClientRequest.writeRequestType()).setSlidingWindowEntry(r.getSlidingWindowEntry()).build();
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type) {
        this(RaftClientRequest.newBuilder().setClientId(clientId).setServerId(serverId).setGroupId(groupId).setCallId(callId).setType(type));
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId leaderId, RaftGroupId groupId, long callId, Type type, long timeoutMs) {
        this(RaftClientRequest.newBuilder().setClientId(clientId).setLeaderId(leaderId).setGroupId(groupId).setCallId(callId).setType(type).setTimeoutMs(timeoutMs));
    }

    private RaftClientRequest(Builder b) {
        super(Builder.access$1500((Builder)b), Builder.access$1600((Builder)b), Builder.access$1700((Builder)b), Builder.access$1800((Builder)b));
        this.toLeader = Builder.access$1900((Builder)b);
        this.message = Builder.access$2000((Builder)b);
        this.type = Builder.access$2100((Builder)b);
        this.repliedCallIds = Optional.ofNullable(Builder.access$2200((Builder)b)).orElseGet(Collections::emptyList);
        this.slidingWindowEntry = Builder.access$2300((Builder)b);
        this.routingTable = Builder.access$2400((Builder)b);
        this.timeoutMs = Builder.access$2500((Builder)b);
    }

    public final boolean isRequest() {
        return true;
    }

    public boolean isToLeader() {
        return this.toLeader;
    }

    public Iterable<Long> getRepliedCallIds() {
        return this.repliedCallIds;
    }

    public RaftProtos.SlidingWindowEntry getSlidingWindowEntry() {
        return this.slidingWindowEntry;
    }

    public Message getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public boolean is(RaftProtos.RaftClientRequestProto.TypeCase typeCase) {
        return this.getType().is(typeCase);
    }

    public boolean isReadOnly() {
        return this.getType().isReadOnly();
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public String toString() {
        return super.toString() + ", seq=" + ProtoUtils.toString((RaftProtos.SlidingWindowEntry)this.slidingWindowEntry) + ", " + this.type + ", " + this.getMessage();
    }

    static /* synthetic */ Type access$700() {
        return WRITE_DEFAULT;
    }

    static /* synthetic */ Type access$800() {
        return DATA_STREAM_DEFAULT;
    }

    static /* synthetic */ Type access$900() {
        return FORWARD_DEFAULT;
    }

    static /* synthetic */ Type access$1000() {
        return READ_NONLINEARIZABLE_DEFAULT;
    }

    static /* synthetic */ Type access$1100() {
        return READ_AFTER_WRITE_CONSISTENT_DEFAULT;
    }

    static /* synthetic */ Type access$1200() {
        return READ_DEFAULT;
    }

    static /* synthetic */ Type access$1300() {
        return STALE_READ_DEFAULT;
    }
}

