/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteStringUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RaftId {
    static final UUID ZERO_UUID = new UUID(0L, 0L);
    static final ByteString ZERO_UUID_BYTESTRING = RaftId.toByteString((UUID)ZERO_UUID);
    private static final int BYTE_LENGTH = 16;
    private final UUID uuid;
    private final Supplier<ByteString> uuidBytes;
    private final Supplier<String> uuidString;

    static UUID toUuid(ByteString bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        Preconditions.assertSame((long)16L, (long)bytes.size(), (String)"bytes.size()");
        ByteBuffer buf = bytes.asReadOnlyByteBuffer();
        return new UUID(buf.getLong(), buf.getLong());
    }

    static ByteString toByteString(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid == null");
        byte[] array = new byte[16];
        ByteBuffer.wrap(array).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return ByteStringUtils.unsafeWrap((byte[])array);
    }

    private RaftId(UUID uuid, Supplier<ByteString> uuidBytes) {
        this.uuid = (UUID)Preconditions.assertNotNull((Object)uuid, (String)"uuid");
        this.uuidBytes = uuidBytes;
        this.uuidString = JavaUtils.memoize(() -> this.createUuidString(uuid));
    }

    RaftId(UUID uuid) {
        this(uuid, (Supplier)JavaUtils.memoize(() -> RaftId.toByteString((UUID)uuid)));
        Preconditions.assertTrue((!uuid.equals(ZERO_UUID) ? 1 : 0) != 0, () -> "Failed to create " + JavaUtils.getClassSimpleName(this.getClass()) + ": UUID " + ZERO_UUID + " is reserved.");
    }

    RaftId(UUID uuid, ByteString bytes) {
        this(uuid, () -> bytes);
        Preconditions.assertTrue((boolean)RaftId.toUuid((ByteString)bytes).equals(uuid));
    }

    String createUuidString(UUID id) {
        String s = id.toString().toUpperCase();
        int i = s.lastIndexOf(45);
        return s.substring(i + 1);
    }

    public ByteString toByteString() {
        return (ByteString)this.uuidBytes.get();
    }

    public String toString() {
        return (String)this.uuidString.get();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RaftId && this.getClass() == other.getClass() && this.uuid.equals(((RaftId)other).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

