/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToLongFunction;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.DataQueue;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedFunctionWithTimeout;
import org.apache.ratis.util.function.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBlockingQueue<E>
extends DataQueue<E> {
    public static final Logger LOG = LoggerFactory.getLogger(DataBlockingQueue.class);
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();

    public DataBlockingQueue(Object name, SizeInBytes byteLimit, int elementLimit, ToLongFunction<E> getNumBytes) {
        super(name, byteLimit, elementLimit, getNumBytes);
    }

    public long getNumBytes() {
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            long l = super.getNumBytes();
            return l;
        }
    }

    public int getNumElements() {
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            int n = super.getNumElements();
            return n;
        }
    }

    public void clear() {
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            super.clear();
            this.notFull.signal();
        }
    }

    public boolean offer(E element) {
        Objects.requireNonNull(element, "element == null");
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            if (super.offer(element)) {
                this.notEmpty.signal();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(E element, TimeDuration timeout) throws InterruptedException {
        Objects.requireNonNull(element, "element == null");
        long nanos = timeout.toLong(TimeUnit.NANOSECONDS);
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            while (true) {
                if (super.offer(element)) {
                    this.notEmpty.signal();
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
                continue;
                break;
            }
        }
    }

    public boolean remove(E e) {
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            boolean removed = super.remove(e);
            if (removed) {
                this.notFull.signal();
            }
            boolean bl = removed;
            return bl;
        }
    }

    public E poll() {
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            Object polled = super.poll();
            if (polled != null) {
                this.notFull.signal();
            }
            Object object = polled;
            return (E)object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public E poll(TimeDuration timeout) throws InterruptedException {
        long nanos = timeout.toLong(TimeUnit.NANOSECONDS);
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            while (true) {
                Object polled;
                if ((polled = super.poll()) != null) {
                    this.notFull.signal();
                    Object object = polled;
                    return (E)object;
                }
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
                continue;
                break;
            }
        }
    }

    public <RESULT, THROWABLE extends Throwable> List<RESULT> pollList(long timeoutMs, CheckedFunctionWithTimeout<E, RESULT, THROWABLE> getResult, TriConsumer<E, TimeDuration, TimeoutException> timeoutHandler) throws THROWABLE {
        try (AutoCloseableLock auto = AutoCloseableLock.acquire((Lock)this.lock);){
            List results = super.pollList(timeoutMs, getResult, timeoutHandler);
            if (!results.isEmpty()) {
                this.notFull.signal();
            }
            List list = results;
            return list;
        }
    }
}

