/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public interface FileUtils {
    public static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    public static final int NUM_ATTEMPTS = 5;
    public static final TimeDuration SLEEP_TIME = TimeDuration.ONE_SECOND;

    public static <T> T attempt(CheckedSupplier<T, IOException> op, Supplier<?> name) throws IOException {
        try {
            return (T)JavaUtils.attempt(op, (int)5, (TimeDuration)SLEEP_TIME, name, (Logger)LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)("Interrupted " + name.get()), (InterruptedException)e);
        }
    }

    public static void truncateFile(File f, long target) throws IOException {
        long original = f.length();
        LogUtils.runAndLog((Logger)LOG, () -> {
            try (FileChannel channel = FileChannel.open(f.toPath(), StandardOpenOption.WRITE);){
                channel.truncate(target);
            }
        }, () -> "FileChannel.truncate " + f + " length: " + original + " -> " + target);
    }

    public static InputStream newInputStream(String s, OpenOption ... options) throws IOException {
        return FileUtils.newInputStream((Path)Paths.get(s, new String[0]), (OpenOption[])options);
    }

    public static InputStream newInputStream(File f, OpenOption ... options) throws IOException {
        return FileUtils.newInputStream((Path)f.toPath(), (OpenOption[])options);
    }

    public static InputStream newInputStream(Path p, OpenOption ... options) throws IOException {
        return (InputStream)LogUtils.supplyAndLog((Logger)LOG, () -> Files.newInputStream(p, options), () -> "Files.newInputStream " + p + " with options " + Arrays.asList(options));
    }

    public static OutputStream newOutputStream(File f, OpenOption ... options) throws IOException {
        return FileUtils.newOutputStream((Path)f.toPath(), (OpenOption[])options);
    }

    public static OutputStream newOutputStream(Path p, OpenOption ... options) throws IOException {
        return (OutputStream)LogUtils.supplyAndLog((Logger)LOG, () -> Files.newOutputStream(p, options), () -> "Files.newOutputStream " + p + " with options " + Arrays.asList(options));
    }

    public static OutputStream newOutputStream(FileChannel channel, boolean forceAtClose) {
        byte[] single = new byte[]{0};
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static OutputStream newOutputStreamForceAtClose(Path p, OpenOption ... options) throws IOException {
        return FileUtils.newOutputStream((FileChannel)FileUtils.newFileChannel((Path)p, (OpenOption[])options), (boolean)true);
    }

    public static OutputStream newOutputStreamForceAtClose(File f, OpenOption ... options) throws IOException {
        return FileUtils.newOutputStreamForceAtClose((Path)f.toPath(), (OpenOption[])options);
    }

    public static FileChannel newFileChannel(File f, OpenOption ... options) throws IOException {
        return FileUtils.newFileChannel((Path)f.toPath(), (OpenOption[])options);
    }

    public static FileChannel newFileChannel(Path p, OpenOption ... options) throws IOException {
        return (FileChannel)LogUtils.supplyAndLog((Logger)LOG, () -> FileChannel.open(p, options), () -> "FileChannel.open " + p + " with options " + Arrays.asList(options));
    }

    public static void createDirectories(File dir) throws IOException {
        FileUtils.createDirectories((Path)dir.toPath());
    }

    public static void createDirectories(Path dir) throws IOException {
        LogUtils.runAndLog((Logger)LOG, () -> Files.createDirectories(dir, new FileAttribute[0]), () -> "Files.createDirectories " + dir);
    }

    public static void createDirectoriesDeleteExistingNonDirectory(File dir) throws IOException {
        FileUtils.createDirectoriesDeleteExistingNonDirectory((Path)dir.toPath());
    }

    public static void createDirectoriesDeleteExistingNonDirectory(Path dir) throws IOException {
        try {
            FileUtils.createDirectories((Path)dir);
        }
        catch (FileAlreadyExistsException e) {
            LOG.warn("Failed to create directory " + dir + " since it already exists as a non-directory.  Trying to delete it ...", (Throwable)e);
            FileUtils.delete((Path)dir);
            FileUtils.createDirectories((Path)dir);
        }
    }

    public static void move(File src, File dst, CopyOption ... options) throws IOException {
        FileUtils.move((Path)src.toPath(), (Path)dst.toPath(), (CopyOption[])options);
    }

    public static void move(Path src, Path dst, CopyOption ... options) throws IOException {
        Objects.requireNonNull(options, "options == null");
        List<CopyOption> original = Arrays.asList(options);
        boolean atomicMove = original.contains(StandardCopyOption.ATOMIC_MOVE);
        if (atomicMove) {
            LogUtils.runAndLog((Logger)LOG, () -> Files.move(src, dst, options), () -> "Files.move " + src + " to " + dst + " with options " + original);
            return;
        }
        CopyOption[] optionsWithAtomicMove = new CopyOption[options.length + 1];
        optionsWithAtomicMove[0] = StandardCopyOption.ATOMIC_MOVE;
        System.arraycopy(options, 0, optionsWithAtomicMove, 1, options.length);
        Supplier<String> suffix = () -> original.isEmpty() ? "" : " with options " + original;
        try {
            LogUtils.runAndLog((Logger)LOG, () -> Files.move(src, dst, optionsWithAtomicMove), () -> "Atomic Files.move " + src + " to " + dst + (String)suffix.get());
        }
        catch (AtomicMoveNotSupportedException e) {
            LogUtils.runAndLog((Logger)LOG, () -> Files.move(src, dst, options), () -> "Atomic move not supported. Fallback to Files.move " + src + " to " + dst + (String)suffix.get());
        }
    }

    public static File move(File src, String suffix) throws IOException {
        File newFile = new File(src.getPath() + suffix);
        FileUtils.move((File)src, (File)newFile, (CopyOption[])new CopyOption[0]);
        return newFile;
    }

    public static void deleteFile(File f) throws IOException {
        FileUtils.delete((Path)f.toPath());
    }

    public static void moveDirectory(Path source, Path dest) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("moveDirectory source: {} dest: {}", (Object)source, (Object)dest);
        }
        FileUtils.createDirectories((Path)dest);
        Files.walkFileTree(source, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        FileUtils.deleteFully((Path)source);
    }

    public static boolean deleteFileQuietly(File f) {
        return FileUtils.deletePathQuietly((Path)f.toPath());
    }

    public static boolean deletePathQuietly(Path p) {
        try {
            FileUtils.delete((Path)p);
            return true;
        }
        catch (Exception ex) {
            LOG.debug("Failed to delete " + p.toAbsolutePath(), (Throwable)ex);
            return false;
        }
    }

    public static void delete(Path p) throws IOException {
        LogUtils.runAndLog((Logger)LOG, () -> Files.delete(p), () -> "Files.delete " + p);
    }

    public static void deleteIfExists(Path p) throws IOException {
        LogUtils.runAndLog((Logger)LOG, () -> Files.deleteIfExists(p), () -> "Files.deleteIfExists " + p);
    }

    public static void deleteIfExists(File f) throws IOException {
        FileUtils.deleteIfExists((Path)f.toPath());
    }

    public static void deleteFully(File f) throws IOException {
        LOG.trace("deleteFully {}", (Object)f);
        FileUtils.deleteFully((Path)f.toPath());
    }

    public static void deleteFully(Path p) throws IOException {
        if (!Files.exists(p, LinkOption.NOFOLLOW_LINKS)) {
            LOG.trace("deleteFully: {} does not exist.", (Object)p);
            return;
        }
        Files.walkFileTree(p, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
    }
}

