/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.JvmPauseMonitor;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JvmPauseMonitor {
    static final Logger LOG = LoggerFactory.getLogger(JvmPauseMonitor.class);
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    private final TimeDuration sleepTime;
    private final TimeDuration sleepDeviationThreshold;
    private final String name;
    private final AtomicReference<Thread> threadRef = new AtomicReference();
    private final CheckedConsumer<TimeDuration, IOException> handler;

    static Map<String, GcInfo> getGcTimes() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().collect(Collectors.toMap(MemoryManagerMXBean::getName, x$0 -> new GcInfo(x$0, null)));
    }

    static String toString(Map<String, GcInfo> beforeSleep, TimeDuration extraSleepTime, Map<String, GcInfo> afterSleep) {
        StringBuilder b = new StringBuilder();
        long ms = 0L;
        for (Map.Entry<String, GcInfo> before : beforeSleep.entrySet()) {
            GcInfo diff;
            String name = before.getKey();
            GcInfo after = afterSleep.get(name);
            if (after == null || GcInfo.access$000((GcInfo)(diff = after.subtract(before.getValue()))) == 0L) continue;
            ms += GcInfo.access$100((GcInfo)diff);
            b.append(System.lineSeparator()).append("GC pool '").append(name).append("' had collection(s): ").append(diff);
        }
        String gc = b.length() == 0 ? " without any GCs." : " with " + TimeDuration.valueOf((long)ms, (TimeUnit)TimeUnit.MILLISECONDS).toString(TimeUnit.SECONDS, 3) + " GC time." + b;
        return "Detected pause in JVM or host machine approximately " + extraSleepTime.toString(TimeUnit.SECONDS, 3) + gc;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private JvmPauseMonitor(Object name, TimeDuration sleepTime, TimeDuration sleepDeviationThreshold, CheckedConsumer<TimeDuration, IOException> handler) {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + "-" + name;
        this.sleepTime = TimeDuration.min((TimeDuration)sleepTime, (TimeDuration)sleepDeviationThreshold);
        this.sleepDeviationThreshold = sleepDeviationThreshold;
        this.handler = handler;
    }

    private void run() {
        LOG.info("{}: Started", (Object)this);
        try {
            while (Thread.currentThread().equals(this.threadRef.get())) {
                this.detectPause();
            }
        }
        finally {
            LOG.info("{}: Stopped", (Object)this);
        }
    }

    private void detectPause() {
        TimeDuration extraSleep;
        Map before = JvmPauseMonitor.getGcTimes();
        try {
            extraSleep = this.sleepTime.sleep();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return;
        }
        if (extraSleep.compareTo(this.sleepDeviationThreshold) > 0) {
            Map after = JvmPauseMonitor.getGcTimes();
            LOG.warn("{}: {}", (Object)this, (Object)JvmPauseMonitor.toString((Map)before, (TimeDuration)extraSleep, (Map)after));
        }
        this.handle(extraSleep);
    }

    private void handle(TimeDuration extraSleep) {
        try {
            this.handler.accept((Object)extraSleep);
        }
        catch (Throwable t) {
            LOG.error("{}: Failed to handle extra sleep {}", new Object[]{this, extraSleep, t});
        }
    }

    public void start() {
        MemoizedSupplier supplier = JavaUtils.memoize(() -> Daemon.newBuilder().setName(JavaUtils.getClassSimpleName(this.getClass()) + THREAD_COUNT.getAndIncrement()).setRunnable(() -> this.run()).build());
        Optional.of(this.threadRef.updateAndGet(previous -> Optional.ofNullable(previous).orElseGet((Supplier<Thread>)supplier))).filter(t -> supplier.isInitialized()).ifPresent(Thread::start);
    }

    public void stop() {
        Thread previous = this.threadRef.getAndSet(null);
        if (previous != null) {
            previous.interrupt();
            try {
                previous.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

