/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public interface LogUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LogUtils.class);

    public static <THROWABLE extends Throwable> void runAndLog(Logger log, CheckedRunnable<THROWABLE> op, Supplier<String> opName) throws THROWABLE {
        try {
            op.run();
        }
        catch (Throwable t) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to " + opName.get(), t);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to " + opName.get() + ": " + t);
            }
            throw t;
        }
        if (log.isTraceEnabled()) {
            log.trace("Successfully ran " + opName.get());
        }
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT supplyAndLog(Logger log, CheckedSupplier<OUTPUT, THROWABLE> supplier, Supplier<String> name) throws THROWABLE {
        Object output;
        try {
            output = supplier.get();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to " + name.get(), (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to " + name.get() + ": " + e);
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace("Successfully supplied " + name.get() + ": " + output);
        }
        return (OUTPUT)output;
    }

    public static Runnable newRunnable(Logger log, Runnable runnable, Supplier<String> name) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <T> Callable<T> newCallable(Logger log, Callable<T> callable, Supplier<String> name) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <OUTPUT, THROWABLE extends Throwable> CheckedSupplier<OUTPUT, THROWABLE> newCheckedSupplier(Logger log, CheckedSupplier<OUTPUT, THROWABLE> supplier, Supplier<String> name) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t, Class<?> ... exceptionClasses) {
        if (log.isWarnEnabled()) {
            if (ReflectionUtils.isInstance((Object)t, (Class[])exceptionClasses)) {
                log.warn(message.get() + ": " + t);
            } else {
                log.warn(message.get(), t);
            }
        }
    }

    public static void infoOrTrace(Logger log, String message, Throwable t) {
        LogUtils.infoOrTrace((Logger)log, () -> message, (Throwable)t);
    }

    public static void infoOrTrace(Logger log, Supplier<String> message, Throwable t) {
        if (log.isTraceEnabled()) {
            log.trace(message.get(), t);
        } else if (log.isInfoEnabled()) {
            log.info("{}: {}", (Object)message.get(), (Object)String.valueOf(t));
        }
    }
}

