/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import org.apache.ratis.util.function.CheckedSupplier;

public final class MemoizedCheckedSupplier<RETURN, THROW extends Throwable>
implements CheckedSupplier<RETURN, THROW> {
    private final CheckedSupplier<RETURN, THROW> initializer;
    private volatile RETURN value = null;

    public static <RETURN, THROW extends Throwable> MemoizedCheckedSupplier<RETURN, THROW> valueOf(CheckedSupplier<RETURN, THROW> supplier) {
        return supplier instanceof MemoizedCheckedSupplier ? (MemoizedCheckedSupplier)supplier : new MemoizedCheckedSupplier(supplier);
    }

    private MemoizedCheckedSupplier(CheckedSupplier<RETURN, THROW> initializer) {
        Objects.requireNonNull(initializer, "initializer == null");
        this.initializer = initializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RETURN get() throws THROW {
        Object v = this.value;
        if (v == null) {
            MemoizedCheckedSupplier memoizedCheckedSupplier = this;
            synchronized (memoizedCheckedSupplier) {
                v = this.value;
                if (v == null) {
                    v = this.value = Objects.requireNonNull(this.initializer.get(), "initializer.get() returns null");
                }
            }
        }
        return (RETURN)v;
    }

    public RETURN getUnchecked() {
        return (RETURN)Objects.requireNonNull(this.value, "value == null");
    }

    public boolean isInitialized() {
        return this.value != null;
    }

    public String toString() {
        return this.isInitialized() ? "Memoized:" + this.value : "UNINITIALIZED";
    }
}

