/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.TimeUnit;
import org.apache.ratis.util.TimeDuration;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Timestamp
implements Comparable<Timestamp> {
    private static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    private static final long START_TIME = System.nanoTime();
    private final long nanos;

    public static Timestamp valueOf(long nanos) {
        return new Timestamp(nanos);
    }

    public static long currentTimeNanos() {
        return System.nanoTime();
    }

    public static Timestamp currentTime() {
        return Timestamp.valueOf((long)Timestamp.currentTimeNanos());
    }

    public static Timestamp latest(Timestamp a, Timestamp b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    public static Timestamp earliest(Timestamp a, Timestamp b) {
        return a.compareTo(b) > 0 ? b : a;
    }

    private Timestamp(long nanos) {
        this.nanos = nanos;
    }

    public Timestamp addTimeMs(long milliseconds) {
        return new Timestamp(this.nanos + milliseconds * 1000000L);
    }

    public Timestamp addTime(TimeDuration t) {
        return new Timestamp(this.nanos + t.to(TimeUnit.NANOSECONDS).getDuration());
    }

    public long elapsedTimeMs() {
        long d = System.nanoTime() - this.nanos;
        return d / 1000000L;
    }

    public TimeDuration elapsedTime() {
        long d = System.nanoTime() - this.nanos;
        return TimeDuration.valueOf((long)d, (TimeUnit)TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Timestamp that) {
        long d = this.nanos - that.nanos;
        return d > 0L ? 1 : (d == 0L ? 0 : -1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timestamp)) {
            return false;
        }
        Timestamp that = (Timestamp)obj;
        return this.nanos == that.nanos;
    }

    public int hashCode() {
        return Long.hashCode(this.nanos);
    }

    public String toString() {
        long ms = (this.nanos - START_TIME) / 1000000L;
        return ms / 1000L + "." + ms % 1000L + TimeDuration.Abbreviation.SECONDS.getDefault();
    }
}

