/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.function.CheckedFunction;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerProxyMap<PROXY extends Closeable>
implements RaftPeer.Add,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(PeerProxyMap.class);
    private final String name;
    private final Map<RaftPeerId, PeerAndProxy> peers = new ConcurrentHashMap<RaftPeerId, PeerAndProxy>();
    private final Object resetLock = new Object();
    private final CheckedFunction<RaftPeer, PROXY, IOException> createProxy;

    public PeerProxyMap(String name, CheckedFunction<RaftPeer, PROXY, IOException> createProxy) {
        this.name = name;
        this.createProxy = createProxy;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PROXY getProxy(RaftPeerId id) throws IOException {
        Objects.requireNonNull(id, "id == null");
        PeerAndProxy p = this.peers.get(id);
        if (p == null) {
            Object object = this.resetLock;
            synchronized (object) {
                p = Objects.requireNonNull(this.peers.get(id), () -> this.name + ": Server " + id + " not found: peers=" + this.peers.keySet());
            }
        }
        return p.getProxy();
    }

    @Override
    public void addRaftPeers(Collection<RaftPeer> newPeers) {
        for (RaftPeer p : newPeers) {
            this.computeIfAbsent(p);
        }
    }

    public CheckedSupplier<PROXY, IOException> computeIfAbsent(RaftPeer peer) {
        PeerAndProxy peerAndProxy = this.peers.computeIfAbsent(peer.getId(), k -> new PeerAndProxy(peer));
        return peerAndProxy::getProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProxy(RaftPeerId id) {
        PeerAndProxy pp;
        LOG.debug("{}: reset proxy for {}", (Object)this.name, (Object)id);
        Optional<Closeable> optional = Optional.empty();
        Object object = this.resetLock;
        synchronized (object) {
            pp = this.peers.remove(id);
            if (pp != null) {
                RaftPeer peer = pp.getPeer();
                optional = pp.setNullProxyAndClose();
                this.computeIfAbsent(peer);
            }
        }
        optional.ifPresent(proxy -> this.closeProxy(proxy, pp));
    }

    public boolean handleException(RaftPeerId serverId, Throwable e, boolean reconnect) {
        if (reconnect || IOUtils.shouldReconnect(e)) {
            this.resetProxy(serverId);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        ConcurrentUtils.parallelForEachAsync(this.peers.values(), pp -> pp.setNullProxyAndClose().ifPresent(proxy -> this.closeProxy((PROXY)proxy, (PeerAndProxy)pp)), r -> new Thread(r).start()).join();
    }

    private void closeProxy(PROXY proxy, PeerAndProxy pp) {
        try {
            LOG.debug("{}: Closing proxy for peer {}", (Object)this.name, (Object)pp);
            proxy.close();
        }
        catch (IOException e) {
            LOG.warn("{}: Failed to close proxy for peer {}, proxy class: {}", new Object[]{this.name, pp, proxy.getClass(), e});
        }
    }

    private class PeerAndProxy {
        private final RaftPeer peer;
        private volatile PROXY proxy = null;
        private final LifeCycle lifeCycle;

        PeerAndProxy(RaftPeer peer) {
            this.peer = peer;
            this.lifeCycle = new LifeCycle(peer);
        }

        RaftPeer getPeer() {
            return this.peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PROXY getProxy() throws IOException {
            if (this.proxy == null) {
                PeerAndProxy peerAndProxy = this;
                synchronized (peerAndProxy) {
                    if (this.proxy == null) {
                        LifeCycle.State current = this.lifeCycle.getCurrentState();
                        if (current.isClosingOrClosed()) {
                            throw new AlreadyClosedException(PeerProxyMap.this.name + " is already " + (Object)((Object)current));
                        }
                        this.lifeCycle.startAndTransition(() -> {
                            this.proxy = (Closeable)PeerProxyMap.this.createProxy.apply(this.peer);
                        }, IOException.class);
                    }
                }
            }
            return this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Optional<PROXY> setNullProxyAndClose() {
            Object p;
            PeerAndProxy peerAndProxy = this;
            synchronized (peerAndProxy) {
                p = this.proxy;
                this.lifeCycle.checkStateAndClose(() -> {
                    this.proxy = null;
                });
            }
            return Optional.ofNullable(p);
        }

        public String toString() {
            return this.peer.toString();
        }
    }
}

