/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedRunnable;
import org.junit.After;
import org.junit.Rule;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@org.junit.jupiter.api.Timeout(value=100L)
public abstract class BaseTest {
    public final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final TimeDuration HUNDRED_MILLIS = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    public static final TimeDuration ONE_SECOND = TimeDuration.ONE_SECOND;
    public static final TimeDuration FIVE_SECONDS = TimeDuration.valueOf((long)5L, (TimeUnit)TimeUnit.SECONDS);
    private final AtomicReference<Throwable> firstException;
    private String testCaseName;
    @Rule
    public final Timeout globalTimeout;
    @Rule
    public final TestName testName;
    private static final Supplier<File> ROOT_TEST_DIR = JavaUtils.memoize(() -> (File)JavaUtils.callAsUnchecked(() -> {
        File dir = new File(System.getProperty("test.build.data", "target/test/data"), Integer.toHexString(ThreadLocalRandom.current().nextInt()));
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException(dir + " already exists and is not a directory");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create test directory " + dir);
        }
        return dir;
    }));

    public BaseTest() {
        Slf4jUtils.setLogLevel(ConfUtils.LOG, Level.WARN);
        Slf4jUtils.setLogLevel(FileUtils.LOG, Level.TRACE);
        ExitUtils.disableSystemExit();
        this.firstException = new AtomicReference();
        this.globalTimeout = new Timeout((long)this.getGlobalTimeoutSeconds(), TimeUnit.SECONDS);
        this.testName = new TestName();
    }

    public void setFirstException(Throwable e) {
        if (this.firstException.compareAndSet(null, e)) {
            this.LOG.error("Set firstException", e);
        }
    }

    public List<RaftPeer> getPeersWithPriority(List<RaftPeer> peers, RaftPeer suggestedLeader) {
        ArrayList<RaftPeer> peersWithPriority = new ArrayList<RaftPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            RaftPeer peer = peers.get(i);
            int priority = peer.equals((Object)suggestedLeader) ? 2 : 1;
            peersWithPriority.add(RaftPeer.newBuilder((RaftPeer)peer).setPriority(priority).build());
        }
        return peersWithPriority;
    }

    @BeforeEach
    public void setup(TestInfo testInfo) {
        this.testCaseName = ((Method)testInfo.getTestMethod().orElseThrow(() -> new RuntimeException("Exception while getting test name."))).getName();
    }

    @After
    @AfterEach
    public void assertNoFailures() {
        Throwable e = this.firstException.get();
        if (e != null) {
            throw new IllegalStateException("Failed: first exception was set", e);
        }
        ExitUtils.assertNotTerminated();
    }

    public int getGlobalTimeoutSeconds() {
        return 100;
    }

    public static File getRootTestDir() {
        return ROOT_TEST_DIR.get();
    }

    public File getClassTestDir() {
        return new File(BaseTest.getRootTestDir(), JavaUtils.getClassSimpleName(this.getClass()));
    }

    public File getTestDir() {
        String name = this.testCaseName != null ? this.testCaseName : this.testName.getMethodName();
        return new File(this.getClassTestDir(), name);
    }

    @SafeVarargs
    public static void assertThrowable(String description, Throwable t, Class<? extends Throwable> expectedThrowableClass, Logger log, Class<? extends Throwable> ... expectedCauseClasses) {
        if (log != null) {
            log.info("Expected the test \"{}\" to throw {} with cause(s) {}", new Object[]{description, expectedThrowableClass.getSimpleName(), StringUtils.array2String((Object[])expectedCauseClasses, Class::getSimpleName)});
        }
        Assertions.assertEquals(expectedThrowableClass, t.getClass());
        for (Class<? extends Throwable> expectedCause : expectedCauseClasses) {
            Throwable previous = t;
            t = Objects.requireNonNull(previous.getCause(), () -> "previous.getCause() == null for previous=" + previous);
            Assertions.assertEquals(expectedCause, t.getClass());
        }
    }

    @SafeVarargs
    public static Throwable testFailureCase(String description, CheckedRunnable<?> testCode, Class<? extends Throwable> expectedThrowableClass, Logger log, Class<? extends Throwable> ... expectedCauseClasses) {
        if (log != null) {
            log.info("run '{}'", (Object)description);
        }
        try {
            testCode.run();
        }
        catch (Throwable t) {
            BaseTest.assertThrowable(description, t, expectedThrowableClass, log, expectedCauseClasses);
            return t;
        }
        throw new AssertionError((Object)("The test \"" + description + "\" does not throw anything."));
    }

    @SafeVarargs
    public final Throwable testFailureCase(String description, CheckedRunnable<?> testCode, Class<? extends Throwable> expectedThrowableClass, Class<? extends Throwable> ... expectedCauseClasses) {
        return BaseTest.testFailureCase(description, testCode, expectedThrowableClass, this.LOG, expectedCauseClasses);
    }

    @SafeVarargs
    public static Throwable testFailureCaseAsync(String description, Supplier<CompletableFuture<?>> testCode, Class<? extends Throwable> expectedThrowableClass, Logger log, Class<? extends Throwable> ... expectedCauseClasses) {
        if (log != null) {
            log.info("run '{}'", (Object)description);
        }
        try {
            testCode.get().join();
        }
        catch (Throwable t) {
            t = JavaUtils.unwrapCompletionException((Throwable)t);
            BaseTest.assertThrowable(description, t, expectedThrowableClass, log, expectedCauseClasses);
            return t;
        }
        throw new AssertionError((Object)("The test \"" + description + "\" does not throw anything."));
    }

    @SafeVarargs
    public final Throwable testFailureCaseAsync(String description, Supplier<CompletableFuture<?>> testCode, Class<? extends Throwable> expectedThrowableClass, Class<? extends Throwable> ... expectedCauseClasses) {
        return BaseTest.testFailureCaseAsync(description, testCode, expectedThrowableClass, this.LOG, expectedCauseClasses);
    }

    static <T> T getWithDefaultTimeout(Future<T> future) throws Exception {
        return future.get(FIVE_SECONDS.getDuration(), FIVE_SECONDS.getUnit());
    }
}

