/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public interface Slf4jUtils {
    public static void setLogLevel(Logger logger, Level level) {
        String prefix;
        String name = logger.getName();
        boolean set = Log4jUtils.setLevel(name, level.name());
        String string = prefix = set ? "Successfully" : "Failed to";
        if (LogUtils.LOG.isTraceEnabled()) {
            LogUtils.LOG.trace("", new Throwable(prefix + " set " + name + " log level to " + level));
        } else {
            LogUtils.LOG.info(prefix + " set {} log level to {}", (Object)name, (Object)level);
        }
    }

    public static interface Log4jUtils {
        public static final String PACKAGE_NAME = "org.apache.log4j";

        public static boolean setLevel(String loggerName, String levelName) {
            Field level = Level.valueOf(levelName);
            if (level == null) {
                return false;
            }
            try {
                Object logger = LogManager.getLogger().invoke(null, loggerName);
                Logger.setLevel().invoke(logger, level.get(null));
            }
            catch (Exception ignored) {
                return false;
            }
            return true;
        }

        public static interface Logger {
            public static final String CLASS_NAME = "org.apache.log4j.Logger";
            public static final Supplier<Method> SET_LEVEL = MemoizedSupplier.valueOf(Logger::setLevelImpl);

            public static Method setLevel() {
                return SET_LEVEL.get();
            }

            public static Method setLevelImpl() {
                Class clazz = ReflectionUtils.getClassByNameOrNull((String)CLASS_NAME);
                if (clazz == null) {
                    return null;
                }
                Class[] argClasses = new Class[]{ReflectionUtils.getClassByNameOrNull((String)"org.apache.log4j.Level")};
                try {
                    return clazz.getMethod("setLevel", argClasses);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }

        public static interface Level {
            public static final String CLASS_NAME = "org.apache.log4j.Level";
            public static final ConcurrentMap<String, Field> LEVELS = new ConcurrentHashMap<String, Field>();

            public static Field valueOf(String level) {
                return LEVELS.computeIfAbsent(level, Level::valueOfImpl);
            }

            public static Field valueOfImpl(String level) {
                try {
                    Class clazz = ReflectionUtils.getClassByNameOrNull((String)CLASS_NAME);
                    return clazz.getDeclaredField(level);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }

        public static interface LogManager {
            public static final String CLASS_NAME = "org.apache.log4j.LogManager";
            public static final Supplier<Method> GET_LOGGER = MemoizedSupplier.valueOf(LogManager::getLoggerImpl);

            public static Method getLogger() {
                return GET_LOGGER.get();
            }

            public static Method getLoggerImpl() {
                Class clazz = ReflectionUtils.getClassByNameOrNull((String)CLASS_NAME);
                if (clazz == null) {
                    return null;
                }
                Class[] argClasses = new Class[]{String.class};
                try {
                    return clazz.getMethod("getLogger", argClasses);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
    }
}

