/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.util.NetUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestNetUtils {
    TestNetUtils() {
    }

    @Test
    void createsUniqueAddresses() {
        for (int i = 0; i < 10; ++i) {
            List addresses = NetUtils.createLocalServerAddress((int)100);
            Assertions.assertEquals(addresses.stream().distinct().collect(Collectors.toList()), (Object)addresses);
        }
    }

    @Test
    void returnsUniquePorts() {
        ArrayList<Integer> addresses = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            addresses.add(NetUtils.getFreePort());
        }
        Assertions.assertEquals(addresses.stream().distinct().collect(Collectors.toList()), addresses);
    }

    @Test
    void skipsUsedPort() throws IOException {
        int port = NetUtils.getFreePort();
        try (ServerSocket ignored = new ServerSocket(port + 1);){
            int nextPort = NetUtils.getFreePort();
            Assertions.assertEquals((int)(port + 2), (int)nextPort);
        }
    }
}

