/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.File;
import java.io.IOException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.util.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileUtils
extends BaseTest {
    @Test
    public void testRenameToCorrupt() throws IOException {
        File dir = this.getClassTestDir();
        Assertions.assertTrue((boolean)dir.mkdirs());
        try {
            TestFileUtils.runTestRenameToCorrupt(dir);
        }
        finally {
            FileUtils.deleteFully((File)dir);
        }
        Assertions.assertFalse((boolean)dir.exists());
    }

    static void runTestRenameToCorrupt(File dir) throws IOException {
        File srcFile = new File(dir, "snapshot.1_20");
        Assertions.assertFalse((boolean)srcFile.exists());
        Assertions.assertTrue((boolean)srcFile.createNewFile());
        Assertions.assertTrue((boolean)srcFile.exists());
        File renamed = FileUtils.move((File)srcFile, (String)".corrupt");
        Assertions.assertNotNull((Object)renamed);
        Assertions.assertTrue((boolean)renamed.exists());
        Assertions.assertFalse((boolean)srcFile.exists());
        FileUtils.deleteFully((File)renamed);
        Assertions.assertFalse((boolean)renamed.exists());
    }
}

