/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ratis.BaseTest;
import org.apache.ratis.util.PureJavaCrc32C;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPureJavaCrc32C
extends BaseTest {
    static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    @Test
    public void testByteBuffer() {
        for (int length = 1; length < 0x100000; length <<= 2) {
            TestPureJavaCrc32C.runTestByteBuffer(length - 1);
            TestPureJavaCrc32C.runTestByteBuffer(length);
            TestPureJavaCrc32C.runTestByteBuffer(length + 1);
        }
    }

    static void runTestByteBuffer(int length) {
        int len;
        byte[] array = new byte[length];
        RANDOM.nextBytes(array);
        ByteBuffer buffer = ByteBuffer.wrap(array);
        PureJavaCrc32C arrayCrc = new PureJavaCrc32C();
        PureJavaCrc32C bufferCrc = new PureJavaCrc32C();
        for (int off = 0; off < array.length; off += len) {
            len = RANDOM.nextInt(array.length - off) + 1;
            arrayCrc.update(array, off, len);
            buffer.position(off).limit(off + len);
            bufferCrc.update(buffer);
            Assertions.assertEquals((long)arrayCrc.getValue(), (long)bufferCrc.getValue());
        }
    }
}

