/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Collection;
import java.util.Set;
import org.apache.ratis.thirdparty.com.google.common.collect.Lists;
import org.apache.ratis.util.RefCountingMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRefCountingMap {
    private RefCountingMap<String, String> map;

    @BeforeEach
    public void setUp() {
        this.map = new RefCountingMap();
    }

    @Test
    public void testPutGet() {
        this.map.put((Object)"foo", () -> "foovalue");
        String v = (String)this.map.get((Object)"foo");
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((Object)"foovalue", (Object)v);
    }

    @Test
    public void testPutMulti() {
        String v1 = (String)this.map.put((Object)"foo", () -> "foovalue");
        String v2 = (String)this.map.put((Object)"foo", () -> "foovalue2");
        String v3 = (String)this.map.put((Object)"foo", () -> "foovalue3");
        String v = (String)this.map.get((Object)"foo");
        Assertions.assertEquals((Object)"foovalue", (Object)v);
        Assertions.assertEquals((Object)v, (Object)v1);
        Assertions.assertEquals((Object)v, (Object)v2);
        Assertions.assertEquals((Object)v, (Object)v3);
    }

    @Test
    public void testPutRemove() {
        this.map.put((Object)"foo", () -> "foovalue");
        String v = (String)this.map.remove((Object)"foo");
        Assertions.assertNull((Object)v);
        v = (String)this.map.get((Object)"foo");
        Assertions.assertNull((Object)v);
    }

    @Test
    public void testPutRemoveMulti() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"foo", () -> "foovalue2");
        this.map.put((Object)"foo", () -> "foovalue3");
        String v = (String)this.map.remove((Object)"foo");
        Assertions.assertEquals((Object)"foovalue", (Object)v);
        v = (String)this.map.remove((Object)"foo");
        Assertions.assertEquals((Object)"foovalue", (Object)v);
        v = (String)this.map.remove((Object)"foo");
        Assertions.assertNull((Object)v);
        v = (String)this.map.get((Object)"foo");
        Assertions.assertNull((Object)v);
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put((Object)"foo", () -> "foovalue");
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.put((Object)"bar", () -> "foovalue2");
        Assertions.assertEquals((int)2, (int)this.map.size());
        this.map.put((Object)"bar", () -> "foovalue3");
        Assertions.assertEquals((int)2, (int)this.map.size());
    }

    @Test
    public void testClear() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"bar", () -> "foovalue2");
        this.map.put((Object)"baz", () -> "foovalue3");
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
    }

    @Test
    public void testKeySet() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"bar", () -> "foovalue2");
        this.map.put((Object)"baz", () -> "foovalue3");
        Set keys = this.map.keySet();
        Assertions.assertEquals((int)3, (int)keys.size());
        Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"}).forEach(v -> Assertions.assertTrue((boolean)keys.contains(v)));
    }

    @Test
    public void testValues() {
        this.map.put((Object)"foo", () -> "foovalue");
        this.map.put((Object)"foo", () -> "foovalue2");
        this.map.put((Object)"bar", () -> "foovalue3");
        this.map.put((Object)"baz", () -> "foovalue4");
        Collection values = this.map.values();
        Assertions.assertEquals((int)3, (int)values.size());
        Lists.newArrayList((Object[])new String[]{"foovalue", "foovalue3", "foovalue4"}).forEach(v -> Assertions.assertTrue((boolean)values.contains(v)));
    }
}

