/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.BaseTest;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.examples.ParameterizedBaseTest;
import org.apache.ratis.examples.arithmetic.ArithmeticStateMachine;
import org.apache.ratis.examples.arithmetic.TestArithmetic;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.GroupManagementBaseTest;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestMultiRaftGroup
extends BaseTest {
    private final AtomicInteger start = new AtomicInteger(3);
    private final int count = 10;

    public static Collection<Object[]> data() throws IOException {
        return ParameterizedBaseTest.getMiniRaftClusters(ArithmeticStateMachine.class, 0, new Class[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testMultiRaftGroup(MiniRaftCluster cluster) throws Exception {
        this.runTestMultiRaftGroup(cluster, 3, 6, 9, 12, 15);
    }

    private void runTestMultiRaftGroup(MiniRaftCluster cluster, int ... idIndex) throws Exception {
        this.runTestMultiRaftGroup(cluster, idIndex, -1);
    }

    private void runTestMultiRaftGroup(MiniRaftCluster cluster, int[] idIndex, int chosen) throws Exception {
        CheckedBiConsumer checker = (c, group) -> {
            try (RaftClient client = c.createClient(group);){
                TestArithmetic.runTestPythagorean(client, this.start.getAndAdd(20), 10);
            }
        };
        GroupManagementBaseTest.runMultiGroupTest((MiniRaftCluster)cluster, (int[])idIndex, (int)chosen, (CheckedBiConsumer)checker);
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
    }
}

