/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.MiniRaftClusterWithGrpc;
import org.apache.ratis.netty.MiniRaftClusterWithNetty;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.AfterAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParameterizedBaseTest
extends BaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(ParameterizedBaseTest.class);
    private static final AtomicReference<MiniRaftCluster> CURRENT_CLUSTER = new AtomicReference();

    public static Collection<Object[]> data() {
        return Collections.emptyList();
    }

    public static void setAndStart(MiniRaftCluster cluster) throws InterruptedException, IOException {
        MiniRaftCluster previous = CURRENT_CLUSTER.getAndSet(cluster);
        if (previous != cluster) {
            if (previous != null) {
                previous.shutdown();
            }
            cluster.start();
            RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        }
    }

    @AfterAll
    public static void shutdownCurrentCluster() {
        MiniRaftCluster cluster = CURRENT_CLUSTER.getAndSet(null);
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static void add(Collection<Object[]> clusters, MiniRaftCluster.Factory factory, String[] ids, RaftProperties properties) {
        clusters.add(new Object[]{factory.newCluster(ids, new String[0], properties)});
    }

    public static Collection<Object[]> getMiniRaftClusters(RaftProperties prop, final int clusterSize, Class<?> ... clusterClasses) {
        List<Class<?>> classes = Arrays.asList(clusterClasses);
        boolean isAll = classes.isEmpty();
        Iterator<String[]> ids = new Iterator<String[]>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public String[] next() {
                return MiniRaftCluster.generateIds((int)clusterSize, (int)(this.i++ * clusterSize));
            }
        };
        ArrayList<Object[]> clusters = new ArrayList<Object[]>();
        if (isAll || classes.contains(MiniRaftClusterWithSimulatedRpc.class)) {
            ParameterizedBaseTest.add(clusters, MiniRaftClusterWithSimulatedRpc.FACTORY, (String[])ids.next(), prop);
        }
        if (isAll || classes.contains(MiniRaftClusterWithGrpc.class)) {
            ParameterizedBaseTest.add(clusters, MiniRaftClusterWithGrpc.FACTORY, (String[])ids.next(), prop);
        }
        if (isAll || classes.contains(MiniRaftClusterWithNetty.class)) {
            ParameterizedBaseTest.add(clusters, MiniRaftClusterWithNetty.FACTORY, (String[])ids.next(), prop);
        }
        for (int i = 0; i < clusters.size(); ++i) {
            LOG.info(i + ": " + JavaUtils.getClassSimpleName(((Object[])clusters.get(i))[0].getClass()));
        }
        LOG.info("#clusters = " + clusters.size());
        return clusters;
    }

    public static <S extends StateMachine> Collection<Object[]> getMiniRaftClusters(Class<S> stateMachineClass, int clusterSize, Class<?> ... clusterClasses) {
        RaftProperties prop = new RaftProperties();
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)prop, (TimeDuration)TimeDuration.valueOf((long)300L, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)prop, (TimeDuration)TimeDuration.valueOf((long)600L, (TimeUnit)TimeUnit.MILLISECONDS));
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, stateMachineClass, StateMachine.class);
        return ParameterizedBaseTest.getMiniRaftClusters(prop, clusterSize, clusterClasses);
    }
}

