/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic;

import java.io.IOException;
import java.util.Collection;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.examples.ParameterizedBaseTest;
import org.apache.ratis.examples.arithmetic.ArithmeticStateMachine;
import org.apache.ratis.examples.arithmetic.expression.BinaryExpression;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.examples.arithmetic.expression.NullValue;
import org.apache.ratis.examples.arithmetic.expression.UnaryExpression;
import org.apache.ratis.examples.arithmetic.expression.Variable;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestArithmetic
extends ParameterizedBaseTest {
    public TestArithmetic() {
        Slf4jUtils.setLogLevel((Logger)ArithmeticStateMachine.LOG, (Level)Level.DEBUG);
    }

    public static Collection<Object[]> data() {
        return TestArithmetic.getMiniRaftClusters(ArithmeticStateMachine.class, 3, new Class[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testPythagorean(MiniRaftCluster cluster) throws Exception {
        TestArithmetic.setAndStart(cluster);
        try (RaftClient client = cluster.createClient();){
            TestArithmetic.runTestPythagorean(client, 3, 10);
        }
    }

    public static void runTestPythagorean(RaftClient client, int start, int count) throws IOException {
        int n;
        Preconditions.assertTrue((count > 0 ? 1 : 0) != 0, () -> "count = " + count + " <= 0");
        Preconditions.assertTrue((start >= 2 ? 1 : 0) != 0, () -> "start = " + start + " < 2");
        Variable a = new Variable("a");
        Variable b = new Variable("b");
        Variable c = new Variable("c");
        Expression pythagorean = UnaryExpression.Op.SQRT.apply((Expression)BinaryExpression.Op.ADD.apply(UnaryExpression.Op.SQUARE.apply((Expression)a), UnaryExpression.Op.SQUARE.apply((Expression)b)));
        int end = start + 2 * count;
        int n2 = n = (start & 1) == 0 ? start + 1 : start;
        while (n < end) {
            int n22 = n * n;
            int half_n2 = n22 / 2;
            TestArithmetic.assign(client, a, n);
            TestArithmetic.assign(client, b, half_n2);
            TestArithmetic.assign(client, c, pythagorean, (double)half_n2 + 1.0);
            TestArithmetic.assignNull(client, a);
            TestArithmetic.assignNull(client, b);
            TestArithmetic.assignNull(client, c);
            n += 2;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGaussLegendre(MiniRaftCluster cluster) throws Exception {
        TestArithmetic.setAndStart(cluster);
        try (RaftClient client = cluster.createClient();){
            this.runGaussLegendre(client);
        }
    }

    void runGaussLegendre(RaftClient client) throws IOException {
        TestArithmetic.defineVariable(client, "a0", 1.0);
        TestArithmetic.defineVariable(client, "b0", (Expression)BinaryExpression.Op.DIV.apply(1.0, UnaryExpression.Op.SQRT.apply(2.0)));
        TestArithmetic.defineVariable(client, "t0", (Expression)BinaryExpression.Op.DIV.apply(1.0, 4.0));
        TestArithmetic.defineVariable(client, "p0", 1.0);
        double previous = 0.0;
        boolean converged = false;
        for (int i = 1; i < 8; ++i) {
            int i_1 = i - 1;
            Variable a0 = new Variable("a" + i_1);
            Variable b0 = new Variable("b" + i_1);
            Variable t0 = new Variable("t" + i_1);
            Variable p0 = new Variable("p" + i_1);
            Variable a1 = TestArithmetic.defineVariable(client, "a" + i, (Expression)BinaryExpression.Op.DIV.apply((Expression)BinaryExpression.Op.ADD.apply((Expression)a0, (Expression)b0), 2.0));
            Variable b1 = TestArithmetic.defineVariable(client, "b" + i, UnaryExpression.Op.SQRT.apply((Expression)BinaryExpression.Op.MULT.apply((Expression)a0, (Expression)b0)));
            Variable t1 = TestArithmetic.defineVariable(client, "t" + i, (Expression)BinaryExpression.Op.SUBTRACT.apply((Expression)t0, (Expression)BinaryExpression.Op.MULT.apply((Expression)p0, UnaryExpression.Op.SQUARE.apply((Expression)BinaryExpression.Op.SUBTRACT.apply((Expression)a0, (Expression)a1)))));
            Variable p1 = TestArithmetic.defineVariable(client, "p" + i, (Expression)BinaryExpression.Op.MULT.apply(2.0, (Expression)p0));
            Variable pi_i = new Variable("pi_" + i);
            Expression e = TestArithmetic.assign(client, pi_i, (Expression)BinaryExpression.Op.DIV.apply(UnaryExpression.Op.SQUARE.apply((Expression)a1), (Expression)t0));
            double pi = e.evaluate(null);
            if (converged) {
                Assertions.assertEquals((double)pi, (double)previous);
            } else if (pi == previous) {
                converged = true;
            }
            LOG.info("{} = {}, converged? {}", new Object[]{pi_i, pi, converged});
            previous = pi;
        }
        Assertions.assertTrue((boolean)converged);
    }

    static Variable defineVariable(RaftClient client, String name, double value) throws IOException {
        Variable x = new Variable(name);
        TestArithmetic.assign(client, x, value);
        return x;
    }

    static Variable defineVariable(RaftClient client, String name, Expression e) throws IOException {
        Variable x = new Variable(name);
        TestArithmetic.assign(client, x, e, null);
        return x;
    }

    static Expression assign(RaftClient client, Variable x, double value) throws IOException {
        return TestArithmetic.assign(client, x, (Expression)new DoubleValue(value), value);
    }

    static void assignNull(RaftClient client, Variable x) throws IOException {
        Expression e = TestArithmetic.assign(client, x, (Expression)NullValue.getInstance());
        Assertions.assertEquals((Object)NullValue.getInstance(), (Object)e);
    }

    static Expression assign(RaftClient client, Variable x, Expression e) throws IOException {
        return TestArithmetic.assign(client, x, e, null);
    }

    static Expression assign(RaftClient client, Variable x, Expression e, Double expected) throws IOException {
        RaftClientReply r = client.io().send((Message)x.assign(e));
        return TestArithmetic.assertRaftClientReply(r, expected);
    }

    static Expression assertRaftClientReply(RaftClientReply reply, Double expected) {
        Assertions.assertTrue((boolean)reply.isSuccess());
        Expression e = Expression.Utils.bytes2Expression((byte[])reply.getMessage().getContent().toByteArray(), (int)0);
        if (expected != null) {
            Assertions.assertEquals((Double)expected, (Double)e.evaluate(null));
        }
        return e;
    }
}

