/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.simulation.MiniRaftClusterWithSimulatedRpc;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.tools.ParseRatisLog;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestArithmeticLogDump
extends BaseTest {
    public static final int NUM_SERVERS = 1;
    protected static final RaftProperties PROPERTIES;
    private final MiniRaftClusterWithSimulatedRpc cluster = (MiniRaftClusterWithSimulatedRpc)MiniRaftClusterWithSimulatedRpc.FACTORY.newCluster(1, this.getProperties());

    public RaftProperties getProperties() {
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)PROPERTIES, (TimeDuration)TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS));
        PROPERTIES.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        return PROPERTIES;
    }

    @BeforeEach
    public void setup() throws IOException {
        Assertions.assertNull((Object)this.cluster.getLeader());
        this.cluster.start();
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testLogDump() throws Exception {
        RaftServer.Division leaderServer = RaftTestUtil.waitForLeader((MiniRaftCluster)this.cluster);
        List files = LogSegmentPath.getLogSegmentPaths((RaftStorage)leaderServer.getRaftStorage());
        Assertions.assertEquals((int)1, (int)files.size());
        this.cluster.shutdown();
        ParseRatisLog.Builder builder = new ParseRatisLog.Builder();
        ParseRatisLog prl = builder.setSegmentFile(((LogSegmentPath)files.get(0)).getPath().toFile()).build();
        prl.dumpSegmentFile();
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        PROPERTIES = new RaftProperties();
    }
}

