/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.cli;

import org.apache.ratis.examples.arithmetic.cli.Assign;
import org.apache.ratis.examples.arithmetic.expression.BinaryExpression;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.examples.arithmetic.expression.UnaryExpression;
import org.apache.ratis.examples.arithmetic.expression.Variable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAssignCli {
    @Test
    public void createExpression() {
        Assertions.assertEquals((Object)new DoubleValue(2.0), (Object)new Assign().createExpression("2.0"));
        Assertions.assertEquals((Object)new DoubleValue(42.0), (Object)new Assign().createExpression("42"));
        Assertions.assertEquals((Object)BinaryExpression.Op.MULT.apply(2.0, (Expression)new Variable("a")), (Object)new Assign().createExpression("2*a"));
        Assertions.assertEquals((Object)BinaryExpression.Op.MULT.apply((Expression)new Variable("v1"), 2.0), (Object)new Assign().createExpression("v1 * 2"));
        Assertions.assertEquals((Object)BinaryExpression.Op.ADD.apply(2.0, 1.0), (Object)new Assign().createExpression("2+1"));
        Assertions.assertEquals((Object)BinaryExpression.Op.SUBTRACT.apply(1.0, 6.0), (Object)new Assign().createExpression("1 - 6"));
        Assertions.assertEquals((Object)BinaryExpression.Op.ADD.apply((Expression)new Variable("a"), (Expression)new Variable("v2")), (Object)new Assign().createExpression("a+v2"));
        Assertions.assertEquals((Object)BinaryExpression.Op.ADD.apply((Expression)new Variable("v1"), (Expression)new Variable("b")), (Object)new Assign().createExpression("v1 + b"));
        Assertions.assertEquals((Object)UnaryExpression.Op.SQRT.apply((Expression)new Variable("a")), (Object)new Assign().createExpression("\u221aa"));
        Assertions.assertEquals((Object)UnaryExpression.Op.SQRT.apply((Expression)new Variable("ABC")), (Object)new Assign().createExpression("\u221aABC"));
        Assertions.assertEquals((Object)UnaryExpression.Op.SQRT.apply(2.0), (Object)new Assign().createExpression("\u221a2"));
        Assertions.assertEquals((Object)UnaryExpression.Op.NEG.apply(2.0), (Object)new Assign().createExpression("~2.0"));
        Assertions.assertEquals((Object)UnaryExpression.Op.MINUS.apply(6.0), (Object)new Assign().createExpression("-6.0"));
    }
}

