/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ratis.BaseTest;
import org.apache.ratis.examples.arithmetic.expression.BinaryExpression;
import org.apache.ratis.examples.arithmetic.expression.DoubleValue;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.examples.arithmetic.expression.UnaryExpression;
import org.apache.ratis.examples.arithmetic.expression.Variable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpression
extends BaseTest {
    public int getGlobalTimeoutSeconds() {
        return 1;
    }

    @Test
    public void testArithmeticUtils() throws Exception {
        ThreadLocalRandom ran = ThreadLocalRandom.current();
        byte[] buf = new byte[1024];
        int offset = 0;
        for (int i = 0; i < 10; ++i) {
            int n = ((Random)ran).nextInt();
            Expression.Utils.int2bytes((int)n, (byte[])buf, (int)offset);
            int m = Expression.Utils.bytes2int((byte[])buf, (int)offset);
            Assertions.assertEquals((int)n, (int)m);
            long n2 = ((Random)ran).nextLong();
            Expression.Utils.long2bytes((long)n2, (byte[])buf, (int)(offset += 4));
            long m2 = Expression.Utils.bytes2long((byte[])buf, (int)offset);
            Assertions.assertEquals((long)n2, (long)m2);
            double n3 = ((Random)ran).nextDouble();
            Expression.Utils.double2bytes((double)n3, (byte[])buf, (int)(offset += 8));
            double m22 = Expression.Utils.bytes2double((byte[])buf, (int)offset);
            Assertions.assertEquals((double)n3, (double)m22);
            offset += 8;
        }
    }

    @Test
    public void testOp() throws Exception {
        byte b;
        for (BinaryExpression.Op op : BinaryExpression.Op.values()) {
            b = op.byteValue();
            Assertions.assertEquals((Object)op, (Object)BinaryExpression.Op.valueOf((byte)b));
        }
        for (BinaryExpression.Op op : UnaryExpression.Op.values()) {
            b = op.byteValue();
            Assertions.assertEquals((Object)op, (Object)UnaryExpression.Op.valueOf((byte)b));
        }
    }

    @Test
    public void testExpression() throws Exception {
        byte[] buf = new byte[1024];
        int offset = 0;
        Variable a = new Variable("pi");
        this.LOG.info("var a: " + a);
        int len = a.toBytes(buf, offset);
        Variable a2 = new Variable(buf, offset);
        this.LOG.info("var a2: " + a2);
        Assertions.assertEquals((Object)a.getName(), (Object)a2.getName());
        Assertions.assertEquals((int)len, (int)a.length());
        Assertions.assertEquals((int)len, (int)a2.length());
        offset += len;
        DoubleValue three = new DoubleValue(3.0);
        this.LOG.info("double three: " + three.evaluate(null));
        len = three.toBytes(buf, offset);
        DoubleValue three2 = new DoubleValue(buf, offset);
        this.LOG.info("double three2: " + three2.evaluate(null));
        Assertions.assertEquals((Double)three.evaluate(null), (Double)three2.evaluate(null));
        Assertions.assertEquals((int)len, (int)three.length());
        Assertions.assertEquals((int)len, (int)three2.length());
    }
}

