/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.counter;

import java.io.IOException;
import java.util.Collection;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.examples.ParameterizedBaseTest;
import org.apache.ratis.examples.counter.server.CounterStateMachine;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestCounter
extends ParameterizedBaseTest {
    public static Collection<Object[]> data() {
        return TestCounter.getMiniRaftClusters(CounterStateMachine.class, 3, new Class[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSeveralCounter(MiniRaftCluster cluster) throws IOException, InterruptedException {
        TestCounter.setAndStart(cluster);
        try (RaftClient client = cluster.createClient();){
            for (int i = 0; i < 10; ++i) {
                client.io().send(Message.valueOf((String)"INCREMENT"));
            }
            RaftClientReply reply1 = client.io().sendReadOnly(Message.valueOf((String)"GET"));
            Assertions.assertEquals((int)10, (int)reply1.getMessage().getContent().asReadOnlyByteBuffer().getInt());
            for (int i = 0; i < 10; ++i) {
                client.io().send(Message.valueOf((String)"INCREMENT"));
            }
            RaftClientReply reply2 = client.io().sendReadOnly(Message.valueOf((String)"GET"));
            Assertions.assertEquals((int)20, (int)reply2.getMessage().getContent().asReadOnlyByteBuffer().getInt());
            for (int i = 0; i < 10; ++i) {
                client.io().send(Message.valueOf((String)"INCREMENT"));
            }
            RaftClientReply reply3 = client.io().sendReadOnly(Message.valueOf((String)"GET"));
            Assertions.assertEquals((int)30, (int)reply3.getMessage().getContent().asReadOnlyByteBuffer().getInt());
        }
    }
}

