/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.filestore.FileStoreClient;
import org.apache.ratis.examples.filestore.FileStoreStateMachine;
import org.apache.ratis.examples.filestore.FileStoreWriter;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.function.CheckedSupplier;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileStoreAsyncBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final Logger LOG = LoggerFactory.getLogger(FileStoreAsyncBaseTest.class);
    static final int NUM_PEERS = 3;

    public FileStoreAsyncBaseTest() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, FileStoreStateMachine.class, StateMachine.class);
        ConfUtils.setFile((arg_0, arg_1) -> ((RaftProperties)p).setFile(arg_0, arg_1), (String)"example.filestore.statemachine.dir", (File)new File(this.getClassTestDir(), "filestore"), (BiConsumer[])new BiConsumer[0]);
    }

    @Test
    public void testFileStoreAsync() throws Exception {
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        FileStoreClient client = new FileStoreClient(cluster.getGroup(), this.getProperties());
        ExecutorService executor = Executors.newFixedThreadPool(20);
        FileStoreAsyncBaseTest.testSingleFile("foo", SizeInBytes.valueOf((String)"2M"), executor, client);
        FileStoreAsyncBaseTest.testMultipleFiles("file", 20, SizeInBytes.valueOf((String)"1M"), executor, client);
        executor.shutdown();
        client.close();
        cluster.shutdown();
    }

    private static void testSingleFile(String path, SizeInBytes fileLength, Executor executor, FileStoreClient client) throws Exception {
        LOG.info("runTestSingleFile with path={}, fileLength={}", (Object)path, (Object)fileLength);
        ((CompletableFuture)((CompletableFuture)FileStoreWriter.newBuilder().setFileName(path).setFileSize(fileLength).setAsyncExecutor(executor).setFileStoreClientSupplier((CheckedSupplier<FileStoreClient, IOException>)((CheckedSupplier)() -> client)).build().writeAsync(false).thenCompose(FileStoreWriter::verifyAsync)).thenCompose(FileStoreWriter::deleteAsync)).get();
    }

    private static void testMultipleFiles(String pathPrefix, int numFile, SizeInBytes fileLength, Executor executor, FileStoreClient client) throws Exception {
        LOG.info("runTestMultipleFile with pathPrefix={}, numFile={}, fileLength={}", new Object[]{pathPrefix, numFile, fileLength});
        ArrayList<Object> writerFutures = new ArrayList<Object>();
        for (int i = 0; i < numFile; ++i) {
            String path = String.format("%s%02d", pathPrefix, i);
            Callable callable = LogUtils.newCallable((Logger)LOG, () -> FileStoreWriter.newBuilder().setFileName(path).setFileSize(fileLength).setAsyncExecutor(executor).setFileStoreClientSupplier((CheckedSupplier<FileStoreClient, IOException>)((CheckedSupplier)() -> client)).build().writeAsync(false), () -> path + ":" + fileLength);
            writerFutures.add(callable.call());
        }
        ArrayList writers = new ArrayList();
        for (CompletableFuture completableFuture : writerFutures) {
            writers.add(completableFuture.get());
        }
        writerFutures.clear();
        for (FileStoreWriter fileStoreWriter : writers) {
            writerFutures.add(fileStoreWriter.verifyAsync().thenCompose(FileStoreWriter::deleteAsync));
        }
        for (CompletableFuture completableFuture : writerFutures) {
            completableFuture.get();
        }
    }
}

