/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.examples.filestore.FileStoreClient;
import org.apache.ratis.examples.filestore.FileStoreStateMachine;
import org.apache.ratis.examples.filestore.FileStoreWriter;
import org.apache.ratis.proto.ExamplesProtos;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileStoreBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final Logger LOG = LoggerFactory.getLogger(FileStoreBaseTest.class);
    static final int NUM_PEERS = 3;

    public FileStoreBaseTest() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, FileStoreStateMachine.class, StateMachine.class);
        ConfUtils.setFile((arg_0, arg_1) -> ((RaftProperties)p).setFile(arg_0, arg_1), (String)"example.filestore.statemachine.dir", (File)new File(this.getClassTestDir(), "filestore"), (BiConsumer[])new BiConsumer[0]);
    }

    FileStoreClient newFileStoreClient(CLUSTER cluster) throws IOException {
        return new FileStoreClient(cluster.getGroup(), this.getProperties());
    }

    @Test
    public void testWatch() throws Exception {
        this.runWithNewCluster(3, cluster -> this.runTestWatch(10, cluster));
    }

    void runTestWatch(int n, CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        AtomicBoolean isStarted = new AtomicBoolean();
        ArrayList<Integer> randomIndices = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            randomIndices.add(i);
        }
        Collections.shuffle(randomIndices);
        LOG.info("randomIndices {}", randomIndices);
        ArrayList completionOrder = new ArrayList();
        String pathFirst = "first";
        String pathSecond = "second";
        ArrayList<CompletionStage> firstList = new ArrayList<CompletionStage>(n);
        ArrayList<CompletionStage> watchSecond = new ArrayList<CompletionStage>(n);
        try (FileStoreClient client = new FileStoreClient(cluster.getGroup(), this.getProperties());){
            for (int i = 0; i < n; ++i) {
                LOG.info("watchAsync {}", (Object)i);
                int index = i;
                CompletionStage f = client.watchAsync("first" + i).whenComplete((reply, e) -> {
                    throw new IllegalStateException("first" + index + " should never be completed.");
                });
                firstList.add(f);
                CompletionStage s2 = client.watchAsync("second" + i).whenComplete((reply, e) -> {
                    Assert.assertNotNull((Object)reply);
                    Assert.assertNull((Object)e);
                    Assert.assertTrue((boolean)isStarted.get());
                    completionOrder.add(index);
                });
                watchSecond.add(s2);
                Assert.assertFalse((boolean)((CompletableFuture)f).isDone());
                Assert.assertFalse((boolean)((CompletableFuture)s2).isDone());
                Assert.assertFalse((boolean)isStarted.get());
            }
            TimeDuration.valueOf((long)(ThreadLocalRandom.current().nextLong(500L) + 100L), (TimeUnit)TimeUnit.MILLISECONDS).sleep(s -> LOG.info("{}", s));
            firstList.stream().map(CompletableFuture::isDone).forEach(Assert::assertFalse);
            watchSecond.stream().map(CompletableFuture::isDone).forEach(Assert::assertFalse);
            Assert.assertFalse((boolean)isStarted.get());
            isStarted.set(true);
            Iterator i = randomIndices.iterator();
            while (i.hasNext()) {
                int i2 = (Integer)i.next();
                FileStoreBaseTest.writeSingleFile("second" + i2, SizeInBytes.ONE_KB, (CheckedSupplier<FileStoreClient, IOException>)((CheckedSupplier)() -> client));
            }
            for (int i3 = 0; i3 < n; ++i3) {
                ExamplesProtos.ReadReplyProto reply2 = (ExamplesProtos.ReadReplyProto)((CompletableFuture)watchSecond.get(i3)).get(100L, TimeUnit.MILLISECONDS);
                LOG.info("reply {}: {}", (Object)i3, (Object)reply2);
                Assert.assertNotNull((Object)reply2);
                Assert.assertEquals((Object)("second" + i3), (Object)reply2.getResolvedPath().toStringUtf8());
            }
            LOG.info("completionOrder {}", completionOrder);
            Assert.assertEquals(randomIndices, completionOrder);
            firstList.stream().map(CompletableFuture::isDone).forEach(Assert::assertFalse);
        }
    }

    @Test
    public void testFileStore() throws Exception {
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        CheckedSupplier newClient = () -> this.newFileStoreClient(cluster);
        FileStoreBaseTest.testSingleFile("foo", SizeInBytes.valueOf((String)"2M"), (CheckedSupplier<FileStoreClient, IOException>)newClient);
        FileStoreBaseTest.testMultipleFiles("file", 20, SizeInBytes.valueOf((String)"1M"), (CheckedSupplier<FileStoreClient, IOException>)newClient);
        cluster.shutdown();
    }

    private static FileStoreWriter writeSingleFile(String path, SizeInBytes fileLength, CheckedSupplier<FileStoreClient, IOException> newClient) throws Exception {
        return FileStoreWriter.newBuilder().setFileName(path).setFileSize(fileLength).setFileStoreClientSupplier(newClient).build().write(false).verify().delete();
    }

    private static void testSingleFile(String path, SizeInBytes fileLength, CheckedSupplier<FileStoreClient, IOException> newClient) throws Exception {
        LOG.info("runTestSingleFile with path={}, fileLength={}", (Object)path, (Object)fileLength);
        FileStoreBaseTest.writeSingleFile(path, fileLength, newClient).close();
    }

    private static void testMultipleFiles(String pathPrefix, int numFile, SizeInBytes fileLength, CheckedSupplier<FileStoreClient, IOException> newClient) throws Exception {
        LOG.info("runTestMultipleFile with pathPrefix={}, numFile={}, fileLength={}", new Object[]{pathPrefix, numFile, fileLength});
        ExecutorService executor = Executors.newFixedThreadPool(20);
        ArrayList<Future<Object>> writerFutures = new ArrayList<Future<Object>>();
        for (int i = 0; i < numFile; ++i) {
            String path = String.format("%s%02d", pathPrefix, i);
            Callable callable = LogUtils.newCallable((Logger)LOG, () -> FileStoreWriter.newBuilder().setFileName(path).setFileSize(fileLength).setFileStoreClientSupplier(newClient).build().write(false), () -> path + ":" + fileLength);
            writerFutures.add(executor.submit(callable));
        }
        ArrayList writers = new ArrayList();
        for (Future future : writerFutures) {
            writers.add(future.get());
        }
        writerFutures.clear();
        for (FileStoreWriter fileStoreWriter : writers) {
            writerFutures.add(executor.submit(() -> w.verify().delete()));
        }
        for (Future future : writerFutures) {
            ((FileStoreWriter)future.get()).close();
        }
        executor.shutdown();
    }
}

