/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.DataStreamTestUtils;
import org.apache.ratis.examples.filestore.FileStoreClient;
import org.apache.ratis.examples.filestore.FileStoreStateMachine;
import org.apache.ratis.examples.filestore.FileStoreWriter;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.LogUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.function.CheckedSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileStoreStreamingBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final Logger LOG = LoggerFactory.getLogger(FileStoreStreamingBaseTest.class);
    static final int NUM_PEERS = 3;

    public FileStoreStreamingBaseTest() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, FileStoreStateMachine.class, StateMachine.class);
        ConfUtils.setFile((arg_0, arg_1) -> ((RaftProperties)p).setFile(arg_0, arg_1), (String)"example.filestore.statemachine.dir", (File)new File(this.getClassTestDir(), "filestore"), (BiConsumer[])new BiConsumer[0]);
    }

    @Test
    public void testFileStoreStreamSingleFile() throws Exception {
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        RaftGroup raftGroup = cluster.getGroup();
        Collection peers = raftGroup.getPeers();
        Assert.assertEquals((long)3L, (long)peers.size());
        RaftPeer primary = (RaftPeer)peers.iterator().next();
        CheckedSupplier newClient = () -> new FileStoreClient(cluster.getGroup(), this.getProperties(), primary);
        RoutingTable routingTable = DataStreamTestUtils.getRoutingTableChainTopology((Iterable)peers, (RaftPeer)primary);
        this.testSingleFile("foo", SizeInBytes.valueOf((String)"2M"), 10000, (CheckedSupplier<FileStoreClient, IOException>)newClient, routingTable);
        this.testSingleFile("bar", SizeInBytes.valueOf((String)"2M"), 1000, (CheckedSupplier<FileStoreClient, IOException>)newClient, routingTable);
        this.testSingleFile("sar", SizeInBytes.valueOf((String)"20M"), 100000, (CheckedSupplier<FileStoreClient, IOException>)newClient, routingTable);
        cluster.shutdown();
    }

    @Test
    public void testFileStoreStreamMultipleFiles() throws Exception {
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        RaftGroup raftGroup = cluster.getGroup();
        Collection peers = raftGroup.getPeers();
        Assert.assertEquals((long)3L, (long)peers.size());
        RaftPeer primary = (RaftPeer)peers.iterator().next();
        CheckedSupplier newClient = () -> new FileStoreClient(cluster.getGroup(), this.getProperties(), primary);
        RoutingTable routingTable = DataStreamTestUtils.getRoutingTableChainTopology((Iterable)peers, (RaftPeer)primary);
        this.testMultipleFiles("foo", 5, SizeInBytes.valueOf((String)"2M"), 10000, (CheckedSupplier<FileStoreClient, IOException>)newClient, routingTable);
        this.testMultipleFiles("bar", 10, SizeInBytes.valueOf((String)"2M"), 1000, (CheckedSupplier<FileStoreClient, IOException>)newClient, routingTable);
        cluster.shutdown();
    }

    private void testSingleFile(String path, SizeInBytes fileLength, int bufferSize, CheckedSupplier<FileStoreClient, IOException> newClient, RoutingTable routingTable) throws Exception {
        LOG.info("runTestSingleFile with path={}, fileLength={}", (Object)path, (Object)fileLength);
        FileStoreWriter.newBuilder().setFileName(path).setFileSize(fileLength).setBufferSize(bufferSize).setFileStoreClientSupplier(newClient).build().streamWriteAndVerify(routingTable);
    }

    private void testMultipleFiles(String pathBase, int numFile, SizeInBytes fileLength, int bufferSize, CheckedSupplier<FileStoreClient, IOException> newClient, RoutingTable routingTable) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(numFile);
        ArrayList writerFutures = new ArrayList();
        for (int i = 0; i < numFile; ++i) {
            String string = pathBase + "-" + i;
            Callable callable = LogUtils.newCallable((Logger)LOG, () -> FileStoreWriter.newBuilder().setFileName(path).setFileSize(fileLength).setBufferSize(bufferSize).setFileStoreClientSupplier(newClient).build().streamWriteAndVerify(routingTable), () -> path);
            writerFutures.add(executor.submit(callable));
        }
        for (Future future : writerFutures) {
            future.get();
        }
    }
}

