/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.DataStreamException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public interface ClientProtoUtils {
    public static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(ByteString requestorId, ByteString replyId, RaftGroupId groupId, Long callId, boolean success) {
        return RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(requestorId).setReplyId(replyId).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(groupId)).setCallId(Optional.ofNullable(callId).orElseGet(CallId::getDefault)).setSuccess(success);
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(ByteString requestorId, RaftPeerId replyId, RaftGroupId groupId) {
        return RaftProtos.RaftRpcRequestProto.newBuilder().setRequestorId(requestorId).setReplyId(replyId.toByteString()).setRaftGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(groupId));
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftGroupMemberId requestorId, RaftPeerId replyId) {
        return ClientProtoUtils.toRaftRpcRequestProtoBuilder(requestorId.getPeerId().toByteString(), replyId, requestorId.getGroupId());
    }

    public static RaftProtos.RaftRpcRequestProto.Builder toRaftRpcRequestProtoBuilder(RaftClientRequest request) {
        RaftProtos.RaftRpcRequestProto.Builder b = ClientProtoUtils.toRaftRpcRequestProtoBuilder(request.getClientId().toByteString(), request.getServerId(), request.getRaftGroupId());
        Optional.ofNullable(request.getSlidingWindowEntry()).ifPresent(b::setSlidingWindowEntry);
        Optional.ofNullable(request.getRoutingTable()).map(RoutingTable::toProto).ifPresent(b::setRoutingTable);
        return b.setCallId(request.getCallId()).setToLeader(request.isToLeader()).addAllRepliedCallIds(request.getRepliedCallIds()).setTimeoutMs(request.getTimeoutMs());
    }

    public static RaftClientRequest.Type toRaftClientRequestType(RaftProtos.RaftClientRequestProto p) {
        switch (p.getTypeCase()) {
            case WRITE: {
                return RaftClientRequest.Type.valueOf(p.getWrite());
            }
            case DATASTREAM: {
                return RaftClientRequest.Type.valueOf(p.getDataStream());
            }
            case FORWARD: {
                return RaftClientRequest.Type.valueOf(p.getForward());
            }
            case MESSAGESTREAM: {
                return RaftClientRequest.Type.valueOf(p.getMessageStream());
            }
            case READ: {
                return RaftClientRequest.Type.valueOf(p.getRead());
            }
            case STALEREAD: {
                return RaftClientRequest.Type.valueOf(p.getStaleRead());
            }
            case WATCH: {
                return RaftClientRequest.Type.valueOf(p.getWatch());
            }
        }
        throw new IllegalArgumentException("Unexpected request type: " + p.getTypeCase() + " in request proto " + p);
    }

    public static RoutingTable getRoutingTable(RaftProtos.RaftRpcRequestProto p) {
        if (!p.hasRoutingTable()) {
            return null;
        }
        RoutingTable.Builder builder = RoutingTable.newBuilder();
        for (RaftProtos.RouteProto routeProto : p.getRoutingTable().getRoutesList()) {
            RaftPeerId from = RaftPeerId.valueOf(routeProto.getPeerId().getId());
            List<RaftPeerId> to = routeProto.getSuccessorsList().stream().map(v -> RaftPeerId.valueOf(v.getId())).collect(Collectors.toList());
            builder.addSuccessors(from, to);
        }
        return builder.build();
    }

    public static RaftClientRequest toRaftClientRequest(RaftProtos.RaftClientRequestProto p) {
        RaftClientRequest.Type type = ClientProtoUtils.toRaftClientRequestType(p);
        RaftProtos.RaftRpcRequestProto request = p.getRpcRequest();
        RaftClientRequest.Builder b = RaftClientRequest.newBuilder();
        RaftPeerId perrId = RaftPeerId.valueOf(request.getReplyId());
        if (request.getToLeader()) {
            b.setLeaderId(perrId);
        } else {
            b.setServerId(perrId);
        }
        if (request.hasSlidingWindowEntry()) {
            b.setSlidingWindowEntry(request.getSlidingWindowEntry());
        }
        return b.setClientId(ClientId.valueOf(request.getRequestorId())).setGroupId(ProtoUtils.toRaftGroupId(request.getRaftGroupId())).setCallId(request.getCallId()).setMessage(ClientProtoUtils.toMessage(p.getMessage())).setType(type).setRepliedCallIds(request.getRepliedCallIdsList()).setRoutingTable(ClientProtoUtils.getRoutingTable(request)).setTimeoutMs(request.getTimeoutMs()).build();
    }

    public static ByteBuffer toRaftClientRequestProtoByteBuffer(RaftClientRequest request) {
        return ClientProtoUtils.toRaftClientRequestProto(request).toByteString().asReadOnlyByteBuffer();
    }

    public static RaftProtos.RaftClientRequestProto toRaftClientRequestProto(RaftClientRequest request) {
        RaftProtos.RaftClientRequestProto.Builder b = RaftProtos.RaftClientRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        if (request.getMessage() != null) {
            b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(request.getMessage()));
        }
        RaftClientRequest.Type type = request.getType();
        switch (type.getTypeCase()) {
            case WRITE: {
                b.setWrite(type.getWrite());
                break;
            }
            case DATASTREAM: {
                b.setDataStream(type.getDataStream());
                break;
            }
            case FORWARD: {
                b.setForward(type.getForward());
                break;
            }
            case MESSAGESTREAM: {
                b.setMessageStream(type.getMessageStream());
                break;
            }
            case READ: {
                b.setRead(type.getRead());
                break;
            }
            case STALEREAD: {
                b.setStaleRead(type.getStaleRead());
                break;
            }
            case WATCH: {
                b.setWatch(type.getWatch());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type: " + request.getType() + " in request " + request);
            }
        }
        return b.build();
    }

    public static RaftProtos.StateMachineExceptionProto.Builder toStateMachineExceptionProtoBuilder(StateMachineException e) {
        Throwable t2 = e.getCause() != null ? e.getCause() : e;
        return RaftProtos.StateMachineExceptionProto.newBuilder().setExceptionClassName(t2.getClass().getName()).setErrorMsg(t2.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString(t2.getStackTrace()));
    }

    public static RaftProtos.AlreadyClosedExceptionProto.Builder toAlreadyClosedExceptionProtoBuilder(AlreadyClosedException ace) {
        Throwable t2 = ace.getCause() != null ? ace.getCause() : ace;
        return RaftProtos.AlreadyClosedExceptionProto.newBuilder().setExceptionClassName(t2.getClass().getName()).setErrorMsg(ace.getMessage()).setStacktrace(ProtoUtils.writeObject2ByteString(ace.getStackTrace()));
    }

    public static RaftProtos.RaftClientReplyProto toRaftClientReplyProto(RaftClientReply reply) {
        RaftProtos.RaftClientReplyProto.Builder b = RaftProtos.RaftClientReplyProto.newBuilder();
        if (reply != null) {
            NotReplicatedException nre;
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            b.setLogIndex(reply.getLogIndex());
            if (reply.getMessage() != null) {
                b.setMessage(ClientProtoUtils.toClientMessageEntryProtoBuilder(reply.getMessage()));
            }
            b.addAllCommitInfos(reply.getCommitInfos());
            NotLeaderException nle = reply.getNotLeaderException();
            if (nle != null) {
                RaftProtos.NotLeaderExceptionProto.Builder nleBuilder = RaftProtos.NotLeaderExceptionProto.newBuilder();
                RaftPeer suggestedLeader = nle.getSuggestedLeader();
                if (suggestedLeader != null) {
                    nleBuilder.setSuggestedLeader(suggestedLeader.getRaftPeerProto());
                }
                nleBuilder.addAllPeersInConf(ProtoUtils.toRaftPeerProtos(nle.getPeers()));
                b.setNotLeaderException(nleBuilder.build());
            }
            if ((nre = reply.getNotReplicatedException()) != null) {
                RaftProtos.NotReplicatedExceptionProto.Builder nreBuilder = RaftProtos.NotReplicatedExceptionProto.newBuilder().setCallId(nre.getCallId()).setReplication(nre.getRequiredReplication()).setLogIndex(nre.getLogIndex());
                b.setNotReplicatedException(nreBuilder);
            }
            Optional.ofNullable(reply.getLeaderNotReadyException()).map(e -> RaftProtos.LeaderNotReadyExceptionProto.newBuilder().setServerId(e.getRaftGroupMemberIdProto())).ifPresent(b::setLeaderNotReadyException);
            Optional.ofNullable(reply.getStateMachineException()).map(ClientProtoUtils::toStateMachineExceptionProtoBuilder).ifPresent(b::setStateMachineException);
            Optional.ofNullable(reply.getDataStreamException()).map(ProtoUtils::toThrowableProto).ifPresent(b::setDataStreamException);
            Optional.ofNullable(reply.getAlreadyClosedException()).map(ClientProtoUtils::toAlreadyClosedExceptionProtoBuilder).ifPresent(b::setAlreadyClosedException);
            Optional.ofNullable(reply.getLeaderSteppingDownException()).map(ProtoUtils::toThrowableProto).ifPresent(b::setLeaderSteppingDownException);
            Optional.ofNullable(reply.getTransferLeadershipException()).map(ProtoUtils::toThrowableProto).ifPresent(b::setTransferLeadershipException);
            Optional.ofNullable(reply.getReadException()).map(ProtoUtils::toThrowableProto).ifPresent(b::setReadException);
            Optional.ofNullable(reply.getReadIndexException()).map(ProtoUtils::toThrowableProto).ifPresent(b::setReadIndexException);
            RaftProtos.RaftClientReplyProto serialized = b.build();
            RaftException e2 = reply.getException();
            if (e2 != null) {
                RaftClientReply deserialized = ClientProtoUtils.toRaftClientReply(serialized);
                if (!Optional.ofNullable(deserialized.getException()).map(Object::getClass).filter(e2.getClass()::equals).isPresent()) {
                    throw new AssertionError("Corruption while serializing reply= " + reply + " but serialized=" + serialized + " and deserialized=" + deserialized, e2);
                }
            }
            return serialized;
        }
        return b.build();
    }

    public static RaftProtos.GroupListReplyProto toGroupListReplyProto(GroupListReply reply) {
        RaftProtos.GroupListReplyProto.Builder b = RaftProtos.GroupListReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getGroupIds() != null) {
                reply.getGroupIds().forEach(groupId -> b.addGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(groupId)));
            }
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoReplyProto toGroupInfoReplyProto(GroupInfoReply reply) {
        RaftProtos.GroupInfoReplyProto.Builder b = RaftProtos.GroupInfoReplyProto.newBuilder();
        if (reply != null) {
            b.setRpcReply(ClientProtoUtils.toRaftRpcReplyProtoBuilder(reply.getClientId().toByteString(), reply.getServerId().toByteString(), reply.getRaftGroupId(), reply.getCallId(), reply.isSuccess()));
            if (reply.getRaftGroupId() != null) {
                b.setGroup(ProtoUtils.toRaftGroupProtoBuilder(reply.getGroup()));
                b.setIsRaftStorageHealthy(reply.isRaftStorageHealthy());
                b.setRole(reply.getRoleInfoProto());
                b.addAllCommitInfos(reply.getCommitInfos());
                b.setLogInfo(reply.getLogInfoProto());
            }
        }
        return b.build();
    }

    public static RaftClientReply getRaftClientReply(DataStreamReply reply) {
        if (!(reply instanceof DataStreamReplyByteBuffer)) {
            throw new IllegalStateException("Unexpected " + reply.getClass() + ": reply is " + reply);
        }
        try {
            return ClientProtoUtils.toRaftClientReply(((DataStreamReplyByteBuffer)reply).slice());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException("Failed to getRaftClientReply from " + reply, e);
        }
    }

    public static RaftClientReply toRaftClientReply(ByteBuffer buffer) throws InvalidProtocolBufferException {
        return ClientProtoUtils.toRaftClientReply(RaftProtos.RaftClientReplyProto.parseFrom(buffer));
    }

    public static RaftClientReply toRaftClientReply(RaftProtos.RaftClientReplyProto replyProto) {
        RaftException e;
        RaftProtos.RaftRpcReplyProto rp = replyProto.getRpcReply();
        RaftGroupMemberId serverMemberId = ProtoUtils.toRaftGroupMemberId(rp.getReplyId(), rp.getRaftGroupId());
        if (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTLEADEREXCEPTION)) {
            RaftProtos.NotLeaderExceptionProto nleProto = replyProto.getNotLeaderException();
            RaftPeer suggestedLeader = nleProto.hasSuggestedLeader() ? ProtoUtils.toRaftPeer(nleProto.getSuggestedLeader()) : null;
            List<RaftPeer> peers = ProtoUtils.toRaftPeers(nleProto.getPeersInConfList());
            e = new NotLeaderException(serverMemberId, suggestedLeader, peers);
        } else if (replyProto.getExceptionDetailsCase() == RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.NOTREPLICATEDEXCEPTION) {
            RaftProtos.NotReplicatedExceptionProto nre = replyProto.getNotReplicatedException();
            e = new NotReplicatedException(nre.getCallId(), nre.getReplication(), nre.getLogIndex(), replyProto.getCommitInfosList());
        } else if (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.STATEMACHINEEXCEPTION)) {
            e = ClientProtoUtils.toStateMachineException(serverMemberId, replyProto.getStateMachineException());
        } else if (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.DATASTREAMEXCEPTION)) {
            e = ProtoUtils.toThrowable(replyProto.getDataStreamException(), DataStreamException.class);
        } else if (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.LEADERNOTREADYEXCEPTION)) {
            RaftProtos.LeaderNotReadyExceptionProto lnreProto = replyProto.getLeaderNotReadyException();
            e = new LeaderNotReadyException(ProtoUtils.toRaftGroupMemberId(lnreProto.getServerId()));
        } else {
            e = replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.ALREADYCLOSEDEXCEPTION) ? ClientProtoUtils.toAlreadyClosedException(replyProto.getAlreadyClosedException()) : (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.LEADERSTEPPINGDOWNEXCEPTION) ? (RaftException)ProtoUtils.toThrowable(replyProto.getLeaderSteppingDownException(), LeaderSteppingDownException.class) : (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.TRANSFERLEADERSHIPEXCEPTION) ? (RaftException)ProtoUtils.toThrowable(replyProto.getTransferLeadershipException(), TransferLeadershipException.class) : (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.READEXCEPTION) ? (RaftException)ProtoUtils.toThrowable(replyProto.getReadException(), ReadException.class) : (replyProto.getExceptionDetailsCase().equals(RaftProtos.RaftClientReplyProto.ExceptionDetailsCase.READINDEXEXCEPTION) ? (RaftException)ProtoUtils.toThrowable(replyProto.getReadIndexException(), ReadIndexException.class) : null))));
        }
        return RaftClientReply.newBuilder().setClientId(ClientId.valueOf(rp.getRequestorId())).setServerId(serverMemberId).setCallId(rp.getCallId()).setSuccess(rp.getSuccess()).setMessage(ClientProtoUtils.toMessage(replyProto.getMessage())).setException(e).setLogIndex(replyProto.getLogIndex()).setCommitInfos(replyProto.getCommitInfosList()).build();
    }

    public static StateMachineException toStateMachineException(RaftGroupMemberId memberId, RaftProtos.StateMachineExceptionProto proto) {
        return ClientProtoUtils.toStateMachineException(memberId, proto.getExceptionClassName(), proto.getErrorMsg(), proto.getStacktrace());
    }

    public static StateMachineException toStateMachineException(RaftGroupMemberId memberId, String className, String errorMsg, ByteString stackTraceBytes) {
        StateMachineException sme;
        if (className == null) {
            sme = new StateMachineException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), errorMsg);
                sme = new StateMachineException(memberId, (Throwable)e);
            }
            catch (Exception e) {
                sme = new StateMachineException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject(stackTraceBytes);
        sme.setStackTrace(stacktrace);
        return sme;
    }

    public static AlreadyClosedException toAlreadyClosedException(RaftProtos.AlreadyClosedExceptionProto proto) {
        return ClientProtoUtils.toAlreadyClosedException(proto.getExceptionClassName(), proto.getErrorMsg(), proto.getStacktrace());
    }

    public static AlreadyClosedException toAlreadyClosedException(String className, String errorMsg, ByteString stackTraceBytes) {
        AlreadyClosedException ace;
        if (className == null) {
            ace = new AlreadyClosedException(errorMsg);
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                Exception e = ReflectionUtils.instantiateException(clazz.asSubclass(Exception.class), errorMsg);
                ace = new AlreadyClosedException(errorMsg, e);
            }
            catch (Exception e) {
                ace = new AlreadyClosedException(className + ": " + errorMsg);
            }
        }
        StackTraceElement[] stacktrace = (StackTraceElement[])ProtoUtils.toObject(stackTraceBytes);
        ace.setStackTrace(stacktrace);
        return ace;
    }

    public static GroupListReply toGroupListReply(RaftProtos.GroupListReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rpc = replyProto.getRpcReply();
        List<RaftGroupId> groupIds = replyProto.getGroupIdList().stream().map(ProtoUtils::toRaftGroupId).collect(Collectors.toList());
        return new GroupListReply(ClientId.valueOf(rpc.getRequestorId()), RaftPeerId.valueOf(rpc.getReplyId()), ProtoUtils.toRaftGroupId(rpc.getRaftGroupId()), rpc.getCallId(), groupIds);
    }

    public static GroupInfoReply toGroupInfoReply(RaftProtos.GroupInfoReplyProto replyProto) {
        RaftProtos.RaftRpcReplyProto rpc = replyProto.getRpcReply();
        return new GroupInfoReply(ClientId.valueOf(rpc.getRequestorId()), RaftPeerId.valueOf(rpc.getReplyId()), ProtoUtils.toRaftGroupId(rpc.getRaftGroupId()), rpc.getCallId(), replyProto.getCommitInfosList(), ProtoUtils.toRaftGroup(replyProto.getGroup()), replyProto.getRole(), replyProto.getIsRaftStorageHealthy(), replyProto.hasConf() ? replyProto.getConf() : null, replyProto.getLogInfo());
    }

    public static Message toMessage(RaftProtos.ClientMessageEntryProto p) {
        return Message.valueOf(p.getContent());
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(ByteString message) {
        return RaftProtos.ClientMessageEntryProto.newBuilder().setContent(message);
    }

    public static RaftProtos.ClientMessageEntryProto.Builder toClientMessageEntryProtoBuilder(Message message) {
        return ClientProtoUtils.toClientMessageEntryProtoBuilder(message.getContent());
    }

    public static SetConfigurationRequest toSetConfigurationRequest(RaftProtos.SetConfigurationRequestProto p) {
        SetConfigurationRequest.Arguments arguments = SetConfigurationRequest.Arguments.newBuilder().setServersInNewConf(ProtoUtils.toRaftPeers(p.getPeersList())).setListenersInNewConf(ProtoUtils.toRaftPeers(p.getListenersList())).setServersInCurrentConf(ProtoUtils.toRaftPeers(p.getCurrentPeersList())).setListenersInCurrentConf(ProtoUtils.toRaftPeers(p.getCurrentListenersList())).setMode(ClientProtoUtils.toSetConfigurationMode(p.getMode())).build();
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        return new SetConfigurationRequest(ClientId.valueOf(m4.getRequestorId()), RaftPeerId.valueOf(m4.getReplyId()), ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), p.getRpcRequest().getCallId(), arguments);
    }

    public static SetConfigurationRequest.Mode toSetConfigurationMode(RaftProtos.SetConfigurationRequestProto.Mode p) {
        switch (p) {
            case SET_UNCONDITIONALLY: {
                return SetConfigurationRequest.Mode.SET_UNCONDITIONALLY;
            }
            case ADD: {
                return SetConfigurationRequest.Mode.ADD;
            }
            case COMPARE_AND_SET: {
                return SetConfigurationRequest.Mode.COMPARE_AND_SET;
            }
        }
        throw new IllegalArgumentException("Unexpected mode " + p);
    }

    public static RaftProtos.SetConfigurationRequestProto toSetConfigurationRequestProto(SetConfigurationRequest request) {
        SetConfigurationRequest.Arguments arguments = request.getArguments();
        return RaftProtos.SetConfigurationRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).addAllPeers(ProtoUtils.toRaftPeerProtos(arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.FOLLOWER))).addAllListeners(ProtoUtils.toRaftPeerProtos(arguments.getPeersInNewConf(RaftProtos.RaftPeerRole.LISTENER))).addAllCurrentPeers(ProtoUtils.toRaftPeerProtos(arguments.getServersInCurrentConf())).addAllCurrentListeners(ProtoUtils.toRaftPeerProtos(arguments.getListenersInCurrentConf())).setMode(RaftProtos.SetConfigurationRequestProto.Mode.valueOf(arguments.getMode().name())).build();
    }

    public static TransferLeadershipRequest toTransferLeadershipRequest(RaftProtos.TransferLeadershipRequestProto p) {
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        RaftPeerId newLeader = p.hasNewLeader() ? ProtoUtils.toRaftPeer(p.getNewLeader()).getId() : null;
        return new TransferLeadershipRequest(ClientId.valueOf(m4.getRequestorId()), RaftPeerId.valueOf(m4.getReplyId()), ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), p.getRpcRequest().getCallId(), newLeader, m4.getTimeoutMs());
    }

    public static RaftProtos.TransferLeadershipRequestProto toTransferLeadershipRequestProto(TransferLeadershipRequest request) {
        RaftProtos.TransferLeadershipRequestProto.Builder b = RaftProtos.TransferLeadershipRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        Optional.ofNullable(request.getNewLeader()).map(l -> RaftPeer.newBuilder().setId((RaftPeerId)l).build()).map(RaftPeer::getRaftPeerProto).ifPresent(b::setNewLeader);
        return b.build();
    }

    public static GroupManagementRequest toGroupManagementRequest(RaftProtos.GroupManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf(m4.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf(m4.getReplyId());
        switch (p.getOpCase()) {
            case GROUPADD: {
                RaftProtos.GroupAddRequestProto add = p.getGroupAdd();
                return GroupManagementRequest.newAdd(clientId, serverId, m4.getCallId(), ProtoUtils.toRaftGroup(add.getGroup()), add.getFormat());
            }
            case GROUPREMOVE: {
                RaftProtos.GroupRemoveRequestProto remove = p.getGroupRemove();
                return GroupManagementRequest.newRemove(clientId, serverId, m4.getCallId(), ProtoUtils.toRaftGroupId(remove.getGroupId()), remove.getDeleteDirectory(), remove.getRenameDirectory());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static GroupInfoRequest toGroupInfoRequest(RaftProtos.GroupInfoRequestProto p) {
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        return new GroupInfoRequest(ClientId.valueOf(m4.getRequestorId()), RaftPeerId.valueOf(m4.getReplyId()), ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), m4.getCallId());
    }

    public static GroupListRequest toGroupListRequest(RaftProtos.GroupListRequestProto p) {
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        return new GroupListRequest(ClientId.valueOf(m4.getRequestorId()), RaftPeerId.valueOf(m4.getReplyId()), ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), m4.getCallId());
    }

    public static RaftProtos.GroupManagementRequestProto toGroupManagementRequestProto(GroupManagementRequest request) {
        GroupManagementRequest.Remove remove;
        RaftProtos.GroupManagementRequestProto.Builder b = RaftProtos.GroupManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        GroupManagementRequest.Add add = request.getAdd();
        if (add != null) {
            b.setGroupAdd(RaftProtos.GroupAddRequestProto.newBuilder().setGroup(ProtoUtils.toRaftGroupProtoBuilder(add.getGroup())).setFormat(add.isFormat()).build());
        }
        if ((remove = request.getRemove()) != null) {
            b.setGroupRemove(RaftProtos.GroupRemoveRequestProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder(remove.getGroupId())).setDeleteDirectory(remove.isDeleteDirectory()).setRenameDirectory(remove.isRenameDirectory()).build());
        }
        return b.build();
    }

    public static SnapshotManagementRequest toSnapshotManagementRequest(RaftProtos.SnapshotManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf(m4.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf(m4.getReplyId());
        switch (p.getOpCase()) {
            case CREATE: {
                return SnapshotManagementRequest.newCreate(clientId, serverId, ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), m4.getCallId(), m4.getTimeoutMs(), p.getCreate().getCreationGap());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static RaftProtos.SnapshotManagementRequestProto toSnapshotManagementRequestProto(SnapshotManagementRequest request) {
        RaftProtos.SnapshotManagementRequestProto.Builder b = RaftProtos.SnapshotManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        SnapshotManagementRequest.Create create = request.getCreate();
        if (create != null) {
            b.setCreate(RaftProtos.SnapshotCreateRequestProto.newBuilder().setCreationGap(create.getCreationGap()).build());
        }
        return b.build();
    }

    public static LeaderElectionManagementRequest toLeaderElectionManagementRequest(RaftProtos.LeaderElectionManagementRequestProto p) {
        RaftProtos.RaftRpcRequestProto m4 = p.getRpcRequest();
        ClientId clientId = ClientId.valueOf(m4.getRequestorId());
        RaftPeerId serverId = RaftPeerId.valueOf(m4.getReplyId());
        switch (p.getOpCase()) {
            case PAUSE: {
                return LeaderElectionManagementRequest.newPause(clientId, serverId, ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), m4.getCallId());
            }
            case RESUME: {
                return LeaderElectionManagementRequest.newResume(clientId, serverId, ProtoUtils.toRaftGroupId(m4.getRaftGroupId()), m4.getCallId());
            }
        }
        throw new IllegalArgumentException("Unexpected op " + p.getOpCase() + " in " + p);
    }

    public static RaftProtos.LeaderElectionManagementRequestProto toLeaderElectionManagementRequestProto(LeaderElectionManagementRequest request) {
        LeaderElectionManagementRequest.Resume resume;
        RaftProtos.LeaderElectionManagementRequestProto.Builder b = RaftProtos.LeaderElectionManagementRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request));
        LeaderElectionManagementRequest.Pause pause = request.getPause();
        if (pause != null) {
            b.setPause(RaftProtos.LeaderElectionPauseRequestProto.newBuilder().build());
        }
        if ((resume = request.getResume()) != null) {
            b.setResume(RaftProtos.LeaderElectionResumeRequestProto.newBuilder().build());
        }
        return b.build();
    }

    public static RaftProtos.GroupInfoRequestProto toGroupInfoRequestProto(GroupInfoRequest request) {
        return RaftProtos.GroupInfoRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).build();
    }

    public static RaftProtos.GroupListRequestProto toGroupListRequestProto(GroupListRequest request) {
        return RaftProtos.GroupListRequestProto.newBuilder().setRpcRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(request)).build();
    }

    public static String toString(RaftProtos.RaftClientRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpc = proto.getRpcRequest();
        return ClientId.valueOf(rpc.getRequestorId()) + "->" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId() + "-" + ProtoUtils.toString(rpc.getSlidingWindowEntry());
    }

    public static String toString(RaftProtos.RaftClientReplyProto proto) {
        RaftProtos.RaftRpcReplyProto rpc = proto.getRpcReply();
        return ClientId.valueOf(rpc.getRequestorId()) + "<-" + rpc.getReplyId().toStringUtf8() + "#" + rpc.getCallId();
    }
}

