/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.Preconditions;

public final class LogSegmentStartEnd
implements Comparable<LogSegmentStartEnd> {
    private static final String LOG_FILE_NAME_PREFIX = "log";
    private static final String IN_PROGRESS = "inprogress";
    private static final Pattern CLOSED_SEGMENT_PATTERN;
    private static final Pattern OPEN_SEGMENT_PATTERN;
    private final long startIndex;
    private final Long endIndex;

    private static String getOpenLogFileName(long startIndex) {
        return "log_inprogress_" + startIndex;
    }

    static Pattern getOpenSegmentPattern() {
        return OPEN_SEGMENT_PATTERN;
    }

    private static String getClosedLogFileName(long startIndex, long endIndex) {
        return "log_" + startIndex + "-" + endIndex;
    }

    static Pattern getClosedSegmentPattern() {
        return CLOSED_SEGMENT_PATTERN;
    }

    static LogSegmentStartEnd valueOf(long startIndex) {
        return new LogSegmentStartEnd(startIndex, null);
    }

    static LogSegmentStartEnd valueOf(long startIndex, Long endIndex) {
        return new LogSegmentStartEnd(startIndex, endIndex);
    }

    static LogSegmentStartEnd valueOf(long startIndex, long endIndex, boolean isOpen) {
        return new LogSegmentStartEnd(startIndex, isOpen ? null : Long.valueOf(endIndex));
    }

    private LogSegmentStartEnd(long startIndex, Long endIndex) {
        Preconditions.assertTrue(startIndex >= 0L);
        Preconditions.assertTrue(endIndex == null || endIndex >= startIndex);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public long getEndIndex() {
        return Optional.ofNullable(this.endIndex).orElse(-1L);
    }

    public boolean isOpen() {
        return this.endIndex == null;
    }

    private String getFileName() {
        return this.isOpen() ? LogSegmentStartEnd.getOpenLogFileName(this.startIndex) : LogSegmentStartEnd.getClosedLogFileName(this.startIndex, this.endIndex);
    }

    File getFile(File dir) {
        return new File(dir, this.getFileName());
    }

    File getFile(RaftStorage storage) {
        return this.getFile(storage.getStorageDir().getCurrentDir());
    }

    @Override
    public int compareTo(LogSegmentStartEnd that) {
        return Comparator.comparingLong(LogSegmentStartEnd::getStartIndex).thenComparingLong(LogSegmentStartEnd::getEndIndex).compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LogSegmentStartEnd that = (LogSegmentStartEnd)obj;
        return this.startIndex == that.startIndex && Objects.equals(this.endIndex, that.endIndex);
    }

    public int hashCode() {
        return Objects.hash(this.startIndex, this.endIndex);
    }

    public String toString() {
        return this.startIndex + "-" + Optional.ofNullable(this.endIndex).map(Object::toString).orElse("");
    }

    static {
        String digits = "(\\d+)";
        CLOSED_SEGMENT_PATTERN = Pattern.compile("log_(\\d+)-(\\d+)");
        OPEN_SEGMENT_PATTERN = Pattern.compile("log_inprogress_(\\d+)(?:\\..*)?");
    }
}

