/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.Optional;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.impl.DelayLocalExecutionInjection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.TimeDuration;

public class MiniRaftClusterWithGrpc
extends MiniRaftCluster.RpcBase {
    public static final MiniRaftCluster.Factory<MiniRaftClusterWithGrpc> FACTORY = new MiniRaftCluster.Factory<MiniRaftClusterWithGrpc>(){

        public MiniRaftClusterWithGrpc newCluster(String[] ids, String[] listenerIds, RaftProperties prop) {
            RaftConfigKeys.Rpc.setType((RaftProperties)prop, (RpcType)SupportedRpcType.GRPC);
            return new MiniRaftClusterWithGrpc(ids, listenerIds, prop, null);
        }
    };
    public static final DelayLocalExecutionInjection SEND_SERVER_REQUEST_INJECTION = new DelayLocalExecutionInjection(new String[]{GrpcService.GRPC_SEND_SERVER_REQUEST});

    public MiniRaftClusterWithGrpc(String[] ids, RaftProperties properties, Parameters parameters) {
        this(ids, new String[0], properties, parameters);
    }

    public MiniRaftClusterWithGrpc(String[] ids, String[] listenerIds, RaftProperties properties, Parameters parameters) {
        super(ids, listenerIds, properties, parameters);
    }

    protected Parameters setPropertiesAndInitParameters(RaftPeerId id, RaftGroup group, RaftProperties properties) {
        GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.getPort(id, group));
        Optional.ofNullable(this.getAddress(id, group, RaftPeer::getClientAddress)).ifPresent(address -> GrpcConfigKeys.Client.setPort((RaftProperties)properties, (int)NetUtils.createSocketAddr((String)address).getPort()));
        Optional.ofNullable(this.getAddress(id, group, RaftPeer::getAdminAddress)).ifPresent(address -> GrpcConfigKeys.Admin.setPort((RaftProperties)properties, (int)NetUtils.createSocketAddr((String)address).getPort()));
        return this.parameters;
    }

    protected void blockQueueAndSetDelay(String leaderId, int delayMs) throws InterruptedException {
        RaftTestUtil.blockQueueAndSetDelay((Iterable)this.getServers(), (DelayLocalExecutionInjection)SEND_SERVER_REQUEST_INJECTION, (String)leaderId, (int)delayMs, (TimeDuration)this.getTimeoutMax());
    }

    public static interface FactoryGet
    extends MiniRaftCluster.Factory.Get<MiniRaftClusterWithGrpc> {
        default public MiniRaftCluster.Factory<MiniRaftClusterWithGrpc> getFactory() {
            return FACTORY;
        }
    }
}

