/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.Timekeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RatisMetrics {
    static final Logger LOG = LoggerFactory.getLogger(RatisMetrics.class);
    public static final String RATIS_APPLICATION_NAME_METRICS = "ratis";
    private final RatisMetricRegistry registry;

    public static String getHeartbeatSuffix(boolean heartbeat) {
        return heartbeat ? "_heartbeat" : "";
    }

    private static <T> Function<Boolean, T> newHeartbeatFunction(String prefix, Function<String, T> function) {
        Object trueValue = function.apply(prefix + RatisMetrics.getHeartbeatSuffix((boolean)true));
        Object falseValue = function.apply(prefix + RatisMetrics.getHeartbeatSuffix((boolean)false));
        return b -> b != false ? trueValue : falseValue;
    }

    protected static <T extends Enum<T>> Map<T, Map<String, LongCounter>> newCounterMaps(Class<T> clazz) {
        EnumMap maps = new EnumMap(clazz);
        Arrays.stream(clazz.getEnumConstants()).forEach(t -> {
            Map cfr_ignored_0 = maps.put((Object)t, new ConcurrentHashMap());
        });
        return Collections.unmodifiableMap(maps);
    }

    protected static <T extends Enum<T>> Map<T, Timekeeper> newTimerMap(Class<T> clazz, Function<T, Timekeeper> constructor) {
        EnumMap map = new EnumMap(clazz);
        Arrays.stream(clazz.getEnumConstants()).forEach(t -> {
            Timekeeper cfr_ignored_0 = (Timekeeper)map.put((Object)t, constructor.apply(t));
        });
        return Collections.unmodifiableMap(map);
    }

    protected static RatisMetricRegistry create(MetricRegistryInfo info) {
        Optional metricRegistry = MetricRegistries.global().get(info);
        return metricRegistry.orElseGet(() -> {
            LOG.debug("Creating {}", (Object)info);
            return MetricRegistries.global().create(info);
        });
    }

    protected RatisMetrics(RatisMetricRegistry registry) {
        this.registry = registry;
    }

    public void unregister() {
        MetricRegistryInfo info = this.registry.getMetricRegistryInfo();
        LOG.debug("Unregistering {}", (Object)info);
        Optional metricRegistry = MetricRegistries.global().get(info);
        if (metricRegistry.isPresent()) {
            MetricRegistries.global().remove(info);
        }
    }

    public final RatisMetricRegistry getRegistry() {
        return this.registry;
    }

    protected Function<Boolean, Timekeeper> newHeartbeatTimer(String prefix) {
        return RatisMetrics.newHeartbeatFunction((String)prefix, arg_0 -> ((RatisMetricRegistry)this.getRegistry()).timer(arg_0));
    }

    protected Function<Boolean, LongCounter> newHeartbeatCounter(String prefix) {
        return RatisMetrics.newHeartbeatFunction((String)prefix, arg_0 -> ((RatisMetricRegistry)this.getRegistry()).counter(arg_0));
    }
}

