/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import java.util.Optional;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisMetrics {
    static final Logger LOG = LoggerFactory.getLogger(RatisMetrics.class);
    public static final String RATIS_APPLICATION_NAME_METRICS = "ratis";
    protected RatisMetricRegistry registry;

    protected static RatisMetricRegistry create(MetricRegistryInfo info) {
        Optional metricRegistry = MetricRegistries.global().get(info);
        return metricRegistry.orElseGet(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating Metrics Registry : {}", (Object)info.getName());
            }
            return MetricRegistries.global().create(info);
        });
    }

    public void unregister() {
        Optional metricRegistry;
        MetricRegistryInfo info = this.registry.getMetricRegistryInfo();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unregistering Metrics Registry : {}", (Object)info.getName());
        }
        if ((metricRegistry = MetricRegistries.global().get(info)).isPresent()) {
            MetricRegistries.global().remove(info);
        }
    }

    public RatisMetricRegistry getRegistry() {
        return this.registry;
    }
}

