/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistriesLoader;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMetricRegistriesLoader {
    @Test
    public void testLoadSinleInstance() {
        MetricRegistries loader = (MetricRegistries)Mockito.mock(MetricRegistries.class);
        MetricRegistries instance = MetricRegistriesLoader.load((List)Lists.newArrayList((Object[])new MetricRegistries[]{loader}));
        Assert.assertEquals((Object)loader, (Object)instance);
    }

    @Test
    public void testLoadMultipleInstances() {
        MetricRegistries loader1 = (MetricRegistries)Mockito.mock(MetricRegistries.class);
        MetricRegistries loader2 = (MetricRegistries)Mockito.mock(MetricRegistries.class);
        MetricRegistries loader3 = (MetricRegistries)Mockito.mock(MetricRegistries.class);
        MetricRegistries instance = MetricRegistriesLoader.load((List)Lists.newArrayList((Object[])new MetricRegistries[]{loader1, loader2, loader3}));
        Assert.assertEquals((Object)loader1, (Object)instance);
        Assert.assertNotEquals((Object)loader2, (Object)instance);
        Assert.assertNotEquals((Object)loader3, (Object)instance);
    }

    @Test
    public void testAddRemoveReporter() {
        AtomicLong cntr = new AtomicLong(0L);
        MetricRegistries r = MetricRegistries.global();
        Consumer<RatisMetricRegistry> reporter = v -> cntr.incrementAndGet();
        Consumer<RatisMetricRegistry> stopReporter = v -> cntr.incrementAndGet();
        r.addReporterRegistration(reporter, stopReporter);
        MetricRegistryInfo info = new MetricRegistryInfo("t1", "t1", "t1", "t1");
        r.create(info);
        Assert.assertTrue((cntr.get() == 1L ? 1 : 0) != 0);
        r.remove(info);
        Assert.assertTrue((cntr.get() == 2L ? 1 : 0) != 0);
        r.removeReporterRegistration(reporter, stopReporter);
        r.create(info);
        Assert.assertTrue((cntr.get() == 2L ? 1 : 0) != 0);
        r.remove(info);
        Assert.assertTrue((cntr.get() == 2L ? 1 : 0) != 0);
    }
}

