/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

public class RatisMetricRegistryImpl
implements RatisMetricRegistry {
    private MetricRegistry metricRegistry = new MetricRegistry();
    private final MetricRegistryInfo info;
    private final Map<String, String> metricNameCache = new ConcurrentHashMap();
    private JmxReporter jmxReporter;
    private ConsoleReporter consoleReporter;

    public RatisMetricRegistryImpl(MetricRegistryInfo info) {
        this.info = info;
    }

    public Timer timer(String name) {
        return this.metricRegistry.timer(this.getMetricName(name));
    }

    public Counter counter(String name) {
        return this.metricRegistry.counter(this.getMetricName(name));
    }

    public boolean remove(String name) {
        return this.metricRegistry.remove(this.getMetricName(name));
    }

    public Gauge gauge(String name, MetricRegistry.MetricSupplier<Gauge> supplier) {
        return this.metricRegistry.gauge(this.getMetricName(name), supplier);
    }

    public Timer timer(String name, MetricRegistry.MetricSupplier<Timer> supplier) {
        return this.metricRegistry.timer(this.getMetricName(name), supplier);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.metricRegistry.getGauges(filter);
    }

    public Counter counter(String name, MetricRegistry.MetricSupplier<Counter> supplier) {
        return this.metricRegistry.counter(this.getMetricName(name), supplier);
    }

    public Histogram histogram(String name) {
        return this.metricRegistry.histogram(this.getMetricName(name));
    }

    public Meter meter(String name) {
        return this.metricRegistry.meter(this.getMetricName(name));
    }

    public Meter meter(String name, MetricRegistry.MetricSupplier<Meter> supplier) {
        return this.metricRegistry.meter(this.getMetricName(name), supplier);
    }

    @VisibleForTesting
    public Metric get(String shortName) {
        return (Metric)this.metricRegistry.getMetrics().get(this.getMetricName(shortName));
    }

    private String getMetricName(String shortName) {
        return this.metricNameCache.computeIfAbsent(shortName, key -> MetricRegistry.name((String)this.info.getName(), (String[])new String[]{shortName}));
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return (T)this.metricRegistry.register(this.getMetricName(name), metric);
    }

    public MetricRegistry getDropWizardMetricRegistry() {
        return this.metricRegistry;
    }

    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }

    public void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + (String)entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.register(prefix + "." + (String)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public void setJmxReporter(JmxReporter jmxReporter) {
        this.jmxReporter = jmxReporter;
    }

    public JmxReporter getJmxReporter() {
        return this.jmxReporter;
    }

    public void setConsoleReporter(ConsoleReporter consoleReporter) {
        this.consoleReporter = consoleReporter;
    }

    public ConsoleReporter getConsoleReporter() {
        return this.consoleReporter;
    }
}

