/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.ratis.thirdparty.io.netty.bootstrap.Bootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.NetUtils;

public class NettyClient
implements Closeable {
    private final LifeCycle lifeCycle = new LifeCycle((Object)JavaUtils.getClassSimpleName(this.getClass()));
    private Channel channel;

    public void connect(String serverAddress, EventLoopGroup group, ChannelInitializer<SocketChannel> initializer) throws InterruptedException {
        InetSocketAddress address = NetUtils.createSocketAddr((String)serverAddress);
        this.lifeCycle.startAndTransition(() -> {
            this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).handler((ChannelHandler)initializer)).connect((SocketAddress)address).sync().channel();
        }, new Class[]{InterruptedException.class});
    }

    @Override
    public void close() {
        this.lifeCycle.checkStateAndClose(() -> this.channel.close().syncUninterruptibly());
    }

    public ChannelFuture writeAndFlush(Object msg) {
        this.lifeCycle.assertCurrentState(LifeCycle.States.RUNNING);
        return this.channel.writeAndFlush(msg);
    }
}

