/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;

public class NettyRpcProxy
implements Closeable {
    private final RaftPeer peer;
    private final Connection connection;
    private final TimeDuration requestTimeoutDuration;

    public static long getCallId(NettyProtos.RaftNettyServerReplyProto proto) {
        switch (1.$SwitchMap$org$apache$ratis$proto$netty$NettyProtos$RaftNettyServerReplyProto$RaftNettyServerReplyCase[proto.getRaftNettyServerReplyCase().ordinal()]) {
            case 1: {
                return proto.getRequestVoteReply().getServerReply().getCallId();
            }
            case 2: {
                return proto.getStartLeaderElectionReply().getServerReply().getCallId();
            }
            case 3: {
                return proto.getAppendEntriesReply().getServerReply().getCallId();
            }
            case 4: {
                return proto.getInstallSnapshotReply().getServerReply().getCallId();
            }
            case 5: {
                return proto.getRaftClientReply().getRpcReply().getCallId();
            }
            case 6: {
                return proto.getExceptionReply().getRpcReply().getCallId();
            }
            case 7: {
                throw new IllegalArgumentException("Reply case not set in proto: " + proto.getRaftNettyServerReplyCase());
            }
        }
        throw new UnsupportedOperationException("Reply case not supported: " + proto.getRaftNettyServerReplyCase());
    }

    public NettyRpcProxy(RaftPeer peer, RaftProperties properties, EventLoopGroup group) throws InterruptedException {
        this.peer = peer;
        this.connection = new Connection(this, group);
        this.requestTimeoutDuration = RaftClientConfigKeys.Rpc.requestTimeout((RaftProperties)properties);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public NettyProtos.RaftNettyServerReplyProto send(RaftProtos.RaftRpcRequestProto request, NettyProtos.RaftNettyServerRequestProto proto) throws IOException {
        CompletableFuture reply = new CompletableFuture();
        ChannelFuture channelFuture = this.connection.offer(proto, reply);
        try {
            channelFuture.sync();
            TimeDuration newDuration = this.requestTimeoutDuration.add(request.getTimeoutMs(), TimeUnit.MILLISECONDS);
            return (NettyProtos.RaftNettyServerReplyProto)reply.get(newDuration.getDuration(), newDuration.getUnit());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)(ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request) + " sending from " + this.peer + " is interrupted."), (InterruptedException)e);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException((ExecutionException)e);
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ RaftPeer access$000(NettyRpcProxy x0) {
        return x0.peer;
    }
}

