/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamRequestFilePositionCount;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.netty.client.NettyClientStreamRpc;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NettyClientStreamRpc
implements DataStreamClientRpc {
    public static final Logger LOG = LoggerFactory.getLogger(NettyClientStreamRpc.class);
    private final String name;
    private final Connection connection;
    private final int flushRequestCountMin;
    private final SizeInBytes flushRequestBytesMin;
    private final OutstandingRequests outstandingRequests = new OutstandingRequests(this);
    private final ConcurrentMap<ClientInvocationId, ReplyQueue> replies = new ConcurrentHashMap();
    private final TimeDuration replyQueueGracePeriod;
    private final TimeoutExecutor timeoutScheduler = TimeoutExecutor.getInstance();

    public NettyClientStreamRpc(RaftPeer server, TlsConf tlsConf, RaftProperties properties) {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + "->" + server;
        this.replyQueueGracePeriod = NettyConfigKeys.DataStream.Client.replyQueueGracePeriod((RaftProperties)properties);
        this.flushRequestCountMin = RaftClientConfigKeys.DataStream.flushRequestCountMin((RaftProperties)properties);
        this.flushRequestBytesMin = RaftClientConfigKeys.DataStream.flushRequestBytesMin((RaftProperties)properties);
        InetSocketAddress address = NetUtils.createSocketAddr((String)server.getDataStreamAddress());
        SslContext sslContext = NettyUtils.buildSslContextForClient((TlsConf)tlsConf);
        this.connection = new Connection(address, new WorkerGroupGetter(properties), () -> NettyClientStreamRpc.newChannelInitializer((InetSocketAddress)address, (SslContext)sslContext, (ChannelInboundHandler)this.getClientHandler()));
    }

    private ChannelInboundHandler getClientHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static ChannelInitializer<SocketChannel> newChannelInitializer(InetSocketAddress address, SslContext sslContext, ChannelInboundHandler handler) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static MessageToMessageEncoder<DataStreamRequestByteBuffer> newEncoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static MessageToMessageEncoder<DataStreamRequestFilePositionCount> newEncoderDataStreamRequestFilePositionCount() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static MessageToMessageEncoder<ByteBuffer> newEncoderByteBuffer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static ByteToMessageDecoder newDecoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public CompletableFuture<DataStreamReply> streamAsync(DataStreamRequest request) {
        CompletableFuture<DataStreamReply> f = new CompletableFuture<DataStreamReply>();
        ClientInvocationId clientInvocationId = ClientInvocationId.valueOf((ClientId)request.getClientId(), (long)request.getStreamId());
        ReplyQueue q = this.replies.computeIfAbsent(clientInvocationId, key -> new ReplyQueue());
        if (!q.offer(f)) {
            f.completeExceptionally(new IllegalStateException(this + ": Failed to offer a future for " + request));
            return f;
        }
        Channel channel = this.connection.getChannelUninterruptibly();
        if (channel == null) {
            f.completeExceptionally((Throwable)new AlreadyClosedException(this + ": Failed to send " + request));
            return f;
        }
        LOG.debug("{}: write {}", (Object)this, (Object)request);
        Function<DataStreamRequest, ChannelFuture> writeMethod = this.outstandingRequests.write(request) ? arg_0 -> ((Channel)channel).writeAndFlush(arg_0) : arg_0 -> ((Channel)channel).write(arg_0);
        writeMethod.apply(request).addListener(future -> {
            if (!future.isSuccess()) {
                IOException e = new IOException(this + ": Failed to send " + request, future.cause());
                LOG.error("Channel write failed", (Throwable)e);
                f.completeExceptionally(e);
            }
        });
        return f;
    }

    public void close() {
        boolean flush = this.outstandingRequests.shouldFlush(true, 0, SizeInBytes.ZERO);
        LOG.debug("flush? {}", (Object)flush);
        if (flush) {
            Optional.ofNullable(this.connection.getChannelUninterruptibly()).map(c -> c.writeAndFlush((Object)DataStreamPacketByteBuffer.EMPTY_BYTE_BUFFER)).ifPresent(f -> f.addListener(dummy -> this.connection.close()));
        } else {
            this.connection.close();
        }
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ int access$000(NettyClientStreamRpc x0) {
        return x0.flushRequestCountMin;
    }

    static /* synthetic */ SizeInBytes access$100(NettyClientStreamRpc x0) {
        return x0.flushRequestBytesMin;
    }

    static /* synthetic */ ConcurrentMap access$200(NettyClientStreamRpc x0) {
        return x0.replies;
    }

    static /* synthetic */ TimeDuration access$300(NettyClientStreamRpc x0) {
        return x0.replyQueueGracePeriod;
    }

    static /* synthetic */ TimeoutExecutor access$400(NettyClientStreamRpc x0) {
        return x0.timeoutScheduler;
    }

    static /* synthetic */ String access$500(NettyClientStreamRpc x0) {
        return x0.name;
    }

    static /* synthetic */ Connection access$600(NettyClientStreamRpc x0) {
        return x0.connection;
    }
}

