/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.client.DataStreamClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.impl.DataStreamReplyByteBuffer;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.NettyUtils;
import org.apache.ratis.netty.metrics.NettyServerStreamRpcMetrics;
import org.apache.ratis.netty.server.DataStreamManagement;
import org.apache.ratis.netty.server.NettyServerStreamRpc;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.server.DataStreamServerRpc;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandler;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ratis.thirdparty.io.netty.channel.ChannelOption;
import org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.ratis.thirdparty.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ratis.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.ratis.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.ratis.thirdparty.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerStreamRpc
implements DataStreamServerRpc {
    public static final Logger LOG = LoggerFactory.getLogger(NettyServerStreamRpc.class);
    private final String name;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ChannelFuture channelFuture;
    private final DataStreamManagement requests;
    private final ProxiesPool proxies;
    private final NettyServerStreamRpcMetrics metrics;

    public NettyServerStreamRpc(RaftServer server, Parameters parameters) {
        this.name = server.getId() + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.metrics = new NettyServerStreamRpcMetrics(this.name);
        this.requests = new DataStreamManagement(server, this.metrics);
        RaftProperties properties = server.getProperties();
        this.proxies = new ProxiesPool(this.name, properties, parameters);
        boolean useEpoll = NettyConfigKeys.DataStream.Server.useEpoll((RaftProperties)properties);
        this.bossGroup = NettyUtils.newEventLoopGroup((String)(this.name + "-bossGroup"), (int)NettyConfigKeys.DataStream.Server.bossGroupSize((RaftProperties)properties), (boolean)useEpoll);
        this.workerGroup = NettyUtils.newEventLoopGroup((String)(this.name + "-workerGroup"), (int)NettyConfigKeys.DataStream.Server.workerGroupSize((RaftProperties)properties), (boolean)useEpoll);
        TlsConf tlsConf = NettyConfigKeys.DataStream.Server.tlsConf((Parameters)parameters);
        SslContext sslContext = NettyUtils.buildSslContextForServer((TlsConf)tlsConf);
        String host = NettyConfigKeys.DataStream.host((RaftProperties)server.getProperties());
        int port = NettyConfigKeys.DataStream.port((RaftProperties)properties);
        InetSocketAddress socketAddress = host == null || host.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        this.channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(this.bossGroup instanceof EpollEventLoopGroup ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)this.newChannelInitializer(sslContext)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).bind((SocketAddress)socketAddress);
    }

    static DataStreamClient newClient(RaftPeer peer, RaftProperties properties, Parameters parameters) {
        return DataStreamClient.newBuilder().setClientId(ClientId.randomId()).setDataStreamServer(peer).setProperties(properties).setParameters(parameters).build();
    }

    public void addRaftPeers(Collection<RaftPeer> newPeers) {
        this.proxies.addRaftPeers(newPeers);
    }

    private ChannelInboundHandler newChannelInboundHandlerAdapter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ChannelInitializer<SocketChannel> newChannelInitializer(SslContext sslContext) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static ByteToMessageDecoder newDecoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static MessageToMessageEncoder<DataStreamReplyByteBuffer> newEncoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void start() {
        this.channelFuture.syncUninterruptibly();
    }

    public InetSocketAddress getInetSocketAddress() {
        this.channelFuture.awaitUninterruptibly();
        return (InetSocketAddress)this.channelFuture.channel().localAddress();
    }

    public void close() {
        try {
            this.channelFuture.channel().close().sync();
            this.bossGroup.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
            this.workerGroup.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
            ConcurrentUtils.shutdownAndWait((TimeDuration)TimeDuration.ONE_SECOND, (ExecutorService)this.bossGroup, timeout -> LOG.warn("{}: bossGroup shutdown timeout in " + timeout, (Object)this));
            ConcurrentUtils.shutdownAndWait((TimeDuration)TimeDuration.ONE_SECOND, (ExecutorService)this.workerGroup, timeout -> LOG.warn("{}: workerGroup shutdown timeout in " + timeout, (Object)this));
        }
        catch (InterruptedException e) {
            LOG.error(this + ": Interrupted close()", (Throwable)e);
        }
        this.proxies.close();
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ NettyServerStreamRpcMetrics access$000(NettyServerStreamRpc x0) {
        return x0.metrics;
    }

    static /* synthetic */ ProxiesPool access$100(NettyServerStreamRpc x0) {
        return x0.proxies;
    }

    static /* synthetic */ DataStreamManagement access$200(NettyServerStreamRpc x0) {
        return x0.requests;
    }

    static /* synthetic */ ChannelInboundHandler access$300(NettyServerStreamRpc x0) {
        return x0.newChannelInboundHandlerAdapter();
    }
}

