/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.netty;

import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.netty.server.NettyRpcService;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.impl.DelayLocalExecutionInjection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.util.TimeDuration;

public class MiniRaftClusterWithNetty
extends MiniRaftCluster.RpcBase {
    public static final MiniRaftCluster.Factory<MiniRaftClusterWithNetty> FACTORY = new MiniRaftCluster.Factory<MiniRaftClusterWithNetty>(){

        public MiniRaftClusterWithNetty newCluster(String[] ids, String[] listenerIds, RaftProperties prop) {
            RaftConfigKeys.Rpc.setType((RaftProperties)prop, (RpcType)SupportedRpcType.NETTY);
            return new MiniRaftClusterWithNetty(ids, listenerIds, prop);
        }
    };
    public static final DelayLocalExecutionInjection SEND_SERVER_REQUEST = new DelayLocalExecutionInjection(new String[]{NettyRpcService.SEND_SERVER_REQUEST});

    protected MiniRaftClusterWithNetty(String[] ids, String[] listenerIds, RaftProperties properties) {
        super(ids, listenerIds, properties, null);
    }

    protected Parameters setPropertiesAndInitParameters(RaftPeerId id, RaftGroup group, RaftProperties properties) {
        NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.getPort(id, group));
        return null;
    }

    protected void blockQueueAndSetDelay(String leaderId, int delayMs) throws InterruptedException {
        RaftTestUtil.blockQueueAndSetDelay((Iterable)this.getServers(), (DelayLocalExecutionInjection)SEND_SERVER_REQUEST, (String)leaderId, (int)delayMs, (TimeDuration)this.getTimeoutMax());
    }

    public static interface FactoryGet
    extends MiniRaftCluster.Factory.Get<MiniRaftClusterWithNetty> {
        default public MiniRaftCluster.Factory<MiniRaftClusterWithNetty> getFactory() {
            return FACTORY;
        }
    }
}

