/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.InstallSnapshotNotificationTests;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.statemachine.RaftSnapshotBaseTest;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstallSnapshotNotificationTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(InstallSnapshotNotificationTests.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 64;
    private static final int PURGE_GAP = 8;
    private static final AtomicReference<SnapshotInfo> leaderSnapshotInfoRef = new AtomicReference();

    public InstallSnapshotNotificationTests() {
        Log4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachine4InstallSnapshotNotificationTests.class, StateMachine.class);
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)prop, (boolean)false);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)prop, (long)64L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)true);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)prop, (int)8);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((long)1024L));
    }

    @Test
    public void testAddNewFollowers() throws Exception {
        this.runWithNewCluster(1, arg_0 -> this.testAddNewFollowers(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAddNewFollowers(CLUSTER cluster) throws Exception {
        List logs;
        int i;
        leaderSnapshotInfoRef.set(null);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftStorageDirectory storageDirectory = cluster.getLeader().getState().getStorage().getStorageDir();
            long nextIndex = cluster.getLeader().getState().getLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)(nextIndex - 64L), (long)nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            logs = storageDirectory.getLogSegmentFiles();
        }
        finally {
            cluster.shutdown();
        }
        LOG.info("Delete logs {}", (Object)logs);
        for (Object path : logs) {
            FileUtils.deleteFully((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        cluster.restart(false);
        try {
            Object path;
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            RaftClient client = cluster.createClient(cluster.getLeader().getId());
            path = null;
            try {
                Assert.assertTrue((boolean)client.send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable nextIndex) {
                path = nextIndex;
                throw nextIndex;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable nextIndex) {
                            ((Throwable)path).addSuppressed(nextIndex);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            SnapshotInfo leaderSnapshotInfo = cluster.getLeader().getStateMachine().getLatestSnapshot();
            boolean set = leaderSnapshotInfoRef.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true);
            cluster.setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            for (RaftServerImpl follower : cluster.getFollowers()) {
                follower.getState().getStorage().getStorageDir().getStateMachineDir();
                Assert.assertEquals((long)leaderSnapshotInfo.getIndex(), (long)follower.getState().getLatestInstalledSnapshotIndex());
            }
            cluster.restartServer(cluster.getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testRestartFollower() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testRestartFollower(arg_0));
    }

    private void testRestartFollower(CLUSTER cluster) throws Exception {
        int i;
        leaderSnapshotInfoRef.set(null);
        RaftServerImpl leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            for (i = 0; i < 127; ++i) {
                RaftClientReply reply = client.send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
        }
        long oldLeaderNextIndex = leader.getState().getLog().getNextIndex();
        LOG.info("{}: oldLeaderNextIndex = {}", (Object)leaderId, (Object)oldLeaderNextIndex);
        List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)(oldLeaderNextIndex - 64L), (long)oldLeaderNextIndex);
        JavaUtils.attemptRepeatedly(() -> {
            Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
            return null;
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
        RaftPeerId followerId = ((RaftServerImpl)cluster.getFollowers().get(0)).getId();
        cluster.killServer(followerId);
        try (RaftClient client = cluster.createClient(leader.getId());){
            Assert.assertTrue((boolean)client.send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
        }
        FIVE_SECONDS.sleep();
        cluster.restartServer(followerId, false);
        RaftServerImpl follower = cluster.getRaftServerImpl(followerId);
        JavaUtils.attempt(() -> {
            long newLeaderNextIndex = leader.getState().getLog().getNextIndex();
            LOG.info("{}: newLeaderNextIndex = {}", (Object)leaderId, (Object)newLeaderNextIndex);
            Assert.assertTrue((newLeaderNextIndex > oldLeaderNextIndex ? 1 : 0) != 0);
            Assert.assertEquals((long)newLeaderNextIndex, (long)follower.getState().getLog().getNextIndex());
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"followerNextIndex", (Logger)LOG);
    }

    static /* synthetic */ AtomicReference access$000() {
        return leaderSnapshotInfoRef;
    }
}

