/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.memory.MemoryRaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MiniRaftCluster
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(MiniRaftCluster.class);
    public static final String CLASS_NAME = MiniRaftCluster.class.getSimpleName();
    public static final String STATEMACHINE_CLASS_KEY = CLASS_NAME + ".statemachine.class";
    private static final StateMachine.Registry STATEMACHINE_REGISTRY_DEFAULT = gid -> new BaseStateMachine();
    private static final TimeDuration RETRY_INTERVAL_DEFAULT = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    private final Supplier<File> rootTestDir = JavaUtils.memoize(() -> new File(BaseTest.getRootTestDir(), this.getClass().getSimpleName() + Integer.toHexString(ThreadLocalRandom.current().nextInt())));
    protected RaftGroup group;
    protected final RaftProperties properties;
    protected final Parameters parameters;
    protected final Map<RaftPeerId, RaftServerProxy> servers = new ConcurrentHashMap();
    protected final Map<RaftPeerId, RaftPeer> peers = new ConcurrentHashMap();
    private volatile StateMachine.Registry stateMachineRegistry = null;
    private final AtomicReference<Timer> timer = new AtomicReference();

    public static RaftGroup initRaftGroup(Collection<String> ids) {
        RaftPeer[] peers = (RaftPeer[])ids.stream().map(RaftPeerId::valueOf).map(id -> new RaftPeer(id, NetUtils.createLocalServerAddress())).toArray(RaftPeer[]::new);
        return RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (RaftPeer[])peers);
    }

    public File getStorageDir(RaftPeerId id) {
        return new File((File)this.rootTestDir.get(), id.toString());
    }

    public static String[] generateIds(int numServers, int base) {
        String[] ids = new String[numServers];
        for (int i = 0; i < numServers; ++i) {
            ids[i] = "s" + (i + base);
        }
        return ids;
    }

    public static int getIdIndex(String id) {
        return Integer.parseInt(id.substring(1));
    }

    protected MiniRaftCluster(String[] ids, RaftProperties properties, Parameters parameters) {
        this.group = MiniRaftCluster.initRaftGroup(Arrays.asList(ids));
        LOG.info("new {} with {}", (Object)this.getClass().getSimpleName(), (Object)this.group);
        this.properties = new RaftProperties(properties);
        this.parameters = parameters;
        ExitUtils.disableSystemExit();
    }

    public RaftProperties getProperties() {
        return this.properties;
    }

    public MiniRaftCluster initServers() {
        LOG.info("servers = " + this.servers);
        if (this.servers.isEmpty()) {
            this.putNewServers(CollectionUtils.as((Iterable)this.group.getPeers(), RaftPeer::getId), true);
        }
        return this;
    }

    public RaftServerProxy putNewServer(RaftPeerId id, RaftGroup group, boolean format) {
        RaftServerProxy s = this.newRaftServer(id, group, format);
        Preconditions.assertTrue((this.servers.put(id, s) == null ? 1 : 0) != 0);
        this.peers.put(id, MiniRaftCluster.toRaftPeer((RaftServerProxy)s));
        return s;
    }

    private Collection<RaftServerProxy> putNewServers(Iterable<RaftPeerId> peers, boolean format) {
        return StreamSupport.stream(peers.spliterator(), false).map(id -> this.putNewServer(id, this.group, format)).collect(Collectors.toList());
    }

    public void start() throws IOException {
        LOG.info(".............................................................. ");
        LOG.info("... ");
        LOG.info("...     Starting " + this.getClass().getSimpleName());
        LOG.info("... ");
        LOG.info(".............................................................. ");
        this.initServers();
        MiniRaftCluster.startServers(this.servers.values());
        this.timer.updateAndGet(t -> t != null ? t : JavaUtils.runRepeatedly(() -> LOG.info("TIMED-PRINT: " + this.printServers()), (long)10L, (long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    public RaftServerImpl restartServer(RaftPeerId serverId, boolean format) throws IOException {
        return this.restartServer(serverId, this.group, format);
    }

    public RaftServerImpl restartServer(RaftPeerId serverId, RaftGroup group, boolean format) throws IOException {
        this.killServer(serverId);
        this.servers.remove(serverId);
        RaftServerProxy proxy = this.putNewServer(serverId, group, format);
        proxy.start();
        return group == null ? null : proxy.getImpl(group.getGroupId());
    }

    public void restart(boolean format) throws IOException {
        this.shutdown();
        ArrayList idList = new ArrayList(this.servers.keySet());
        this.servers.clear();
        this.putNewServers(idList, format);
        this.start();
    }

    public TimeDuration getTimeoutMax() {
        return RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)this.properties);
    }

    private RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, boolean format) {
        LOG.info("newRaftServer: {}, {}, format? {}", new Object[]{id, group, format});
        try {
            File dir = this.getStorageDir(id);
            if (format) {
                FileUtils.deleteFully((File)dir);
                LOG.info("Formatted directory {}", (Object)dir);
            }
            RaftProperties prop = new RaftProperties(this.properties);
            RaftServerConfigKeys.setStorageDir((RaftProperties)prop, Collections.singletonList(dir));
            return this.newRaftServer(id, this.getStateMachineRegistry(this.properties), group, prop);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract RaftServerProxy newRaftServer(RaftPeerId var1, StateMachine.Registry var2, RaftGroup var3, RaftProperties var4) throws IOException;

    public void setStateMachineRegistry(StateMachine.Registry stateMachineRegistry) {
        this.stateMachineRegistry = stateMachineRegistry;
    }

    StateMachine.Registry getStateMachineRegistry(RaftProperties properties) {
        if (this.stateMachineRegistry != null) {
            return this.stateMachineRegistry;
        }
        Class smClass = properties.getClass(STATEMACHINE_CLASS_KEY, null, StateMachine.class);
        if (smClass == null) {
            return STATEMACHINE_REGISTRY_DEFAULT;
        }
        return gid -> {
            try {
                return (StateMachine)ReflectionUtils.newInstance((Class)smClass);
            }
            catch (RuntimeException e) {
                RuntimeException exception = e;
                try {
                    Class[] argClasses = new Class[]{RaftProperties.class};
                    return (StateMachine)ReflectionUtils.newInstance((Class)smClass, (Class[])argClasses, (Object[])new Object[]{properties});
                }
                catch (RuntimeException e2) {
                    exception.addSuppressed(e2);
                    throw exception;
                }
            }
        };
    }

    public static List<RaftPeer> toRaftPeers(Collection<RaftServerProxy> servers) {
        return servers.stream().map(MiniRaftCluster::toRaftPeer).collect(Collectors.toList());
    }

    public static RaftPeer toRaftPeer(RaftServerImpl s) {
        return MiniRaftCluster.toRaftPeer((RaftServerProxy)s.getProxy());
    }

    public static RaftPeer toRaftPeer(RaftServerProxy s) {
        return new RaftPeer(s.getId(), s.getServerRpc().getInetSocketAddress());
    }

    public PeerChanges addNewPeers(int number, boolean startNewPeer) throws IOException {
        return this.addNewPeers(MiniRaftCluster.generateIds((int)number, (int)this.servers.size()), startNewPeer);
    }

    public PeerChanges addNewPeers(String[] ids, boolean startNewPeer) throws IOException {
        LOG.info("Add new peers {}", Arrays.asList(ids));
        Collection newServers = this.putNewServers(CollectionUtils.as(Arrays.asList(ids), RaftPeerId::valueOf), true);
        MiniRaftCluster.startServers((Iterable)newServers);
        if (!startNewPeer) {
            newServers.forEach(p -> p.close());
        }
        List newPeers = MiniRaftCluster.toRaftPeers((Collection)newServers);
        RaftPeer[] np = newPeers.toArray(new RaftPeer[newPeers.size()]);
        newPeers.addAll(this.group.getPeers());
        RaftPeer[] p2 = newPeers.toArray(new RaftPeer[newPeers.size()]);
        this.group = RaftGroup.valueOf((RaftGroupId)this.group.getGroupId(), (RaftPeer[])p2);
        return new PeerChanges(p2, np, new RaftPeer[0]);
    }

    static void startServers(Iterable<? extends RaftServer> servers) throws IOException {
        for (RaftServer raftServer : servers) {
            raftServer.start();
        }
    }

    public PeerChanges removePeers(int number, boolean removeLeader, Collection<RaftPeer> excluded) throws InterruptedException {
        ArrayList peers = new ArrayList(this.group.getPeers());
        ArrayList<RaftPeer> removedPeers = new ArrayList<RaftPeer>(number);
        if (removeLeader) {
            RaftPeer leader = MiniRaftCluster.toRaftPeer((RaftServerImpl)RaftTestUtil.waitForLeader((MiniRaftCluster)this));
            Preconditions.assertTrue((!excluded.contains(leader) ? 1 : 0) != 0);
            peers.remove(leader);
            removedPeers.add(leader);
        }
        List followers = this.getFollowers();
        int removed = 0;
        for (int i = 0; i < followers.size() && removed < (removeLeader ? number - 1 : number); ++i) {
            RaftPeer toRemove = MiniRaftCluster.toRaftPeer((RaftServerImpl)((RaftServerImpl)followers.get(i)));
            if (excluded.contains(toRemove)) continue;
            peers.remove(toRemove);
            removedPeers.add(toRemove);
            ++removed;
        }
        RaftPeer[] p = peers.toArray(RaftPeer.emptyArray());
        this.group = RaftGroup.valueOf((RaftGroupId)this.group.getGroupId(), (RaftPeer[])p);
        return new PeerChanges(p, RaftPeer.emptyArray(), removedPeers.toArray(RaftPeer.emptyArray()));
    }

    public void killServer(RaftPeerId id) {
        LOG.info("killServer " + id);
        ((RaftServerProxy)this.servers.get(id)).close();
    }

    public String printServers() {
        return this.printServers(null);
    }

    public String printServers(RaftGroupId groupId) {
        StringBuilder b = new StringBuilder("printing ");
        if (groupId != null) {
            b.append(groupId);
        } else {
            b.append("ALL groups");
        }
        this.getRaftServerProxyStream(groupId).forEach(s -> b.append("\n  ").append(s));
        return b.toString();
    }

    public String printAllLogs() {
        StringBuilder b = new StringBuilder("\n#servers = " + this.servers.size() + "\n");
        for (RaftServerImpl s : this.iterateServerImpls()) {
            b.append("  ");
            b.append(s).append("\n");
            RaftLog log = s.getState().getLog();
            if (!(log instanceof MemoryRaftLog)) continue;
            b.append("    ");
            b.append(((MemoryRaftLog)log).getEntryString());
        }
        return b.toString();
    }

    public RaftServerImpl getLeaderAndSendFirstMessage(boolean ignoreException) throws IOException {
        RaftServerImpl leader;
        block14: {
            leader = this.getLeader();
            try (RaftClient client = this.createClient(leader.getId());){
                client.send((Message)new RaftTestUtil.SimpleMessage("first msg to make leader ready"));
            }
            catch (IOException e) {
                if (ignoreException) break block14;
                throw e;
            }
        }
        return leader;
    }

    IllegalStateException newIllegalStateExceptionForNoLeaders(RaftGroupId groupId) {
        String g = groupId == null ? "" : " for " + groupId;
        return new IllegalStateException("No leader yet " + g + ": " + this.printServers(groupId));
    }

    IllegalStateException newIllegalStateExceptionForMultipleLeaders(RaftGroupId groupId, List<RaftServerImpl> leaders) {
        String g = groupId == null ? "" : " for " + groupId;
        return new IllegalStateException("Found multiple leaders" + g + " at the same term (=" + leaders.get(0).getState().getCurrentTerm() + "), leaders.size() = " + leaders.size() + " > 1, leaders = " + leaders + ": " + this.printServers(groupId));
    }

    public RaftServerImpl getLeader() {
        return MiniRaftCluster.getLeader((List)this.getLeaders(null), null, (T leaders) -> {
            throw this.newIllegalStateExceptionForMultipleLeaders(null, leaders);
        });
    }

    RaftServerImpl getLeader(RaftGroupId groupId, Runnable handleNoLeaders, Consumer<List<RaftServerImpl>> handleMultipleLeaders) {
        return MiniRaftCluster.getLeader((List)this.getLeaders(groupId), (Runnable)handleNoLeaders, handleMultipleLeaders);
    }

    static RaftServerImpl getLeader(List<RaftServerImpl> leaders, Runnable handleNoLeaders, Consumer<List<RaftServerImpl>> handleMultipleLeaders) {
        if (leaders.isEmpty()) {
            if (handleNoLeaders != null) {
                handleNoLeaders.run();
            }
            return null;
        }
        if (leaders.size() > 1) {
            if (handleMultipleLeaders != null) {
                handleMultipleLeaders.accept(leaders);
            }
            return null;
        }
        return leaders.get(0);
    }

    private List<RaftServerImpl> getLeaders(RaftGroupId groupId) {
        Stream serverAliveStream = this.getServerAliveStream(groupId);
        ArrayList<RaftServerImpl> leaders = new ArrayList<RaftServerImpl>();
        serverAliveStream.filter(RaftServerImpl::isLeader).forEach(s -> {
            if (leaders.isEmpty()) {
                leaders.add((RaftServerImpl)s);
            } else {
                long leaderTerm = ((RaftServerImpl)leaders.get(0)).getState().getCurrentTerm();
                long term = s.getState().getCurrentTerm();
                if (term >= leaderTerm) {
                    if (term > leaderTerm) {
                        leaders.clear();
                    }
                    leaders.add((RaftServerImpl)s);
                }
            }
        });
        return leaders;
    }

    boolean isLeader(String leaderId) {
        RaftServerImpl leader = this.getLeader();
        return leader != null && leader.getId().toString().equals(leaderId);
    }

    public List<RaftServerImpl> getFollowers() {
        return this.getServerAliveStream().filter(RaftServerImpl::isFollower).collect(Collectors.toList());
    }

    public Collection<RaftServerProxy> getServers() {
        return this.servers.values();
    }

    private Stream<RaftServerProxy> getRaftServerProxyStream(RaftGroupId groupId) {
        return this.getServers().stream().filter(s -> groupId == null || s.containsGroup(groupId));
    }

    public Iterable<RaftServerImpl> iterateServerImpls() {
        return CollectionUtils.as((Iterable)this.getServers(), arg_0 -> this.getRaftServerImpl(arg_0));
    }

    private Stream<RaftServerImpl> getServerStream(RaftGroupId groupId) {
        Stream stream = this.getRaftServerProxyStream(groupId);
        return groupId != null ? stream.filter(s -> s.containsGroup(groupId)).map(s -> RaftServerTestUtil.getRaftServerImpl((RaftServerProxy)s, (RaftGroupId)groupId)) : stream.flatMap(s -> RaftServerTestUtil.getRaftServerImpls((RaftServerProxy)s).stream());
    }

    public Stream<RaftServerImpl> getServerAliveStream() {
        return this.getServerAliveStream(this.getGroupId());
    }

    private Stream<RaftServerImpl> getServerAliveStream(RaftGroupId groupId) {
        return this.getServerStream(groupId).filter(RaftServerImpl::isAlive);
    }

    private RetryPolicy getDefaultRetryPolicy() {
        return RetryPolicies.retryForeverWithSleep((TimeDuration)RETRY_INTERVAL_DEFAULT);
    }

    public RaftServerProxy getServer(RaftPeerId id) {
        return (RaftServerProxy)this.servers.get(id);
    }

    public RaftServerImpl getRaftServerImpl(RaftPeerId id) {
        return this.getRaftServerImpl((RaftServerProxy)this.servers.get(id));
    }

    public RaftServerImpl getRaftServerImpl(RaftServerProxy proxy) {
        return RaftServerTestUtil.getRaftServerImpl((RaftServerProxy)proxy, (RaftGroupId)this.getGroupId());
    }

    public List<RaftPeer> getPeers() {
        return MiniRaftCluster.toRaftPeers((Collection)this.getServers());
    }

    public RaftGroup getGroup() {
        return this.group;
    }

    public RaftClient createClient() {
        return this.createClient(null, this.group);
    }

    public RaftClient createClient(RaftGroup g) {
        return this.createClient(null, g);
    }

    public RaftClient createClient(RaftPeerId leaderId) {
        return this.createClient(leaderId, this.group);
    }

    public RaftClient createClient(RetryPolicy retryPolicy) {
        return this.createClient(null, this.group, retryPolicy);
    }

    public RaftClient createClient(RaftPeerId leaderId, RetryPolicy retryPolicy) {
        return this.createClient(leaderId, this.group, retryPolicy);
    }

    public RaftClient createClient(RaftPeerId leaderId, RaftGroup group) {
        return this.createClient(leaderId, group, this.getDefaultRetryPolicy());
    }

    public RaftClient createClient(RaftPeerId leaderId, RaftGroup group, RetryPolicy retryPolicy) {
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leaderId).setProperties(this.properties).setParameters(this.parameters).setRetryPolicy(retryPolicy);
        return builder.build();
    }

    public RaftClientRequest newRaftClientRequest(ClientId clientId, RaftPeerId leaderId, Message message) {
        return this.newRaftClientRequest(clientId, leaderId, 0L, message);
    }

    public RaftClientRequest newRaftClientRequest(ClientId clientId, RaftPeerId leaderId, long callId, Message message) {
        return new RaftClientRequest(clientId, leaderId, this.getGroupId(), callId, message, RaftClientRequest.writeRequestType(), null);
    }

    public SetConfigurationRequest newSetConfigurationRequest(ClientId clientId, RaftPeerId leaderId, RaftPeer ... peers) {
        return new SetConfigurationRequest(clientId, leaderId, this.getGroupId(), 0L, Arrays.asList(peers));
    }

    public void setConfiguration(RaftPeer ... peers) throws IOException {
        try (RaftClient client = this.createClient();){
            LOG.info("Start changing the configuration: {}", Arrays.asList(peers));
            RaftClientReply reply = client.setConfiguration(peers);
            Preconditions.assertTrue((boolean)reply.isSuccess());
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        LOG.info("************************************************************** ");
        LOG.info("*** ");
        LOG.info("***     Stopping " + this.getClass().getSimpleName());
        LOG.info("*** ");
        LOG.info("************************************************************** ");
        LOG.info(this.printServers());
        ExitUtils.setTerminateOnUncaughtException((boolean)false);
        ExecutorService executor = Executors.newFixedThreadPool(this.servers.size(), Daemon::new);
        this.getServers().forEach(proxy -> executor.submit(() -> ((RaftServerProxy)proxy).close()));
        try {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("shutdown interrupted", (Throwable)e);
        }
        Optional.ofNullable(this.timer.get()).ifPresent(Timer::cancel);
        ExitUtils.assertNotTerminated();
        LOG.info(this.getClass().getSimpleName() + " shutdown completed");
    }

    protected abstract void blockQueueAndSetDelay(String var1, int var2) throws InterruptedException;

    public boolean tryEnforceLeader(String leaderId) throws InterruptedException {
        if (this.isLeader(leaderId)) {
            return true;
        }
        this.blockQueueAndSetDelay(leaderId, RaftServerConfigKeys.Rpc.TIMEOUT_MIN_DEFAULT.toIntExact(TimeUnit.MILLISECONDS));
        this.blockQueueAndSetDelay(leaderId, 0);
        return this.isLeader(leaderId);
    }

    public abstract void setBlockRequestsFrom(String var1, boolean var2);

    public RaftGroupId getGroupId() {
        return this.group.getGroupId();
    }
}

