/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.MiniRaftCluster;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.client.impl.OrderedAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.AlreadyClosedException;
import org.apache.ratis.protocol.GroupMismatchException;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.statemachine.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class RaftAsyncExceptionTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public RaftAsyncExceptionTests() {
        Log4jUtils.setLogLevel((Logger)OrderedAsync.LOG, (Level)Level.DEBUG);
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
    }

    @Test
    public void testGroupMismatchException() throws Exception {
        RaftClientConfigKeys.Async.Experimental.setSendDummyRequest((RaftProperties)this.getProperties(), (boolean)false);
        this.runWithNewCluster(1, arg_0 -> this.runTestGroupMismatchException(arg_0));
        RaftClientConfigKeys.Async.Experimental.setSendDummyRequest((RaftProperties)this.getProperties(), (boolean)true);
    }

    private void runTestGroupMismatchException(CLUSTER cluster) throws Exception {
        try (RaftClient client = cluster.createClient();){
            RaftClientReply reply = (RaftClientReply)client.sendAsync((Message)new RaftTestUtil.SimpleMessage("first")).get();
            Assert.assertTrue((boolean)reply.isSuccess());
        }
        RaftGroup clusterGroup = cluster.getGroup();
        RaftGroup anotherGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (Collection)clusterGroup.getPeers());
        Assert.assertNotEquals((Object)clusterGroup.getGroupId(), (Object)anotherGroup.getGroupId());
        RaftTestUtil.SimpleMessage[] messages = RaftTestUtil.SimpleMessage.create((int)5);
        try (RaftClient client = cluster.createClient(anotherGroup);){
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (RaftTestUtil.SimpleMessage m : messages) {
                futures.add(client.sendAsync((Message)m));
            }
            Assert.assertEquals((long)messages.length, (long)futures.size());
            Iterator i = futures.iterator();
            this.testFailureCase("First reply is GroupMismatchException", () -> {
                RaftClientReply cfr_ignored_0 = (RaftClientReply)((CompletableFuture)i.next()).get();
            }, ExecutionException.class, new Class[]{GroupMismatchException.class});
            while (i.hasNext()) {
                this.testFailureCase("Following replies are AlreadyClosedException caused by GroupMismatchException", () -> {
                    RaftClientReply cfr_ignored_0 = (RaftClientReply)((CompletableFuture)i.next()).get();
                }, ExecutionException.class, new Class[]{AlreadyClosedException.class, GroupMismatchException.class});
            }
        }
    }

    @Test
    public void testTimeoutException() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestTimeoutException(arg_0));
    }

    private void runTestTimeoutException(CLUSTER cluster) throws Exception {
        try (RaftClient client = cluster.createClient();){
            RaftClientReply reply = client.send((Message)new RaftTestUtil.SimpleMessage("m0"));
            Assert.assertTrue((boolean)reply.isSuccess());
            RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)((RaftProperties)properties.get()), (TimeDuration)ONE_SECOND);
            cluster.getServers().stream().map(arg_0 -> cluster.getRaftServerImpl(arg_0)).map(SimpleStateMachine4Testing::get).forEach(SimpleStateMachine4Testing::blockStartTransaction);
            CompletableFuture replyFuture = client.sendAsync((Message)new RaftTestUtil.SimpleMessage("m1"));
            FIVE_SECONDS.sleep();
            cluster.getServers().stream().map(arg_0 -> cluster.getRaftServerImpl(arg_0)).map(SimpleStateMachine4Testing::get).forEach(SimpleStateMachine4Testing::unblockStartTransaction);
            Assert.assertTrue((boolean)((RaftClientReply)replyFuture.get(FIVE_SECONDS.getDuration(), FIVE_SECONDS.getUnit())).isSuccess());
        }
    }
}

